/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.acl.rev151001.access.lists.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.acl.rev151001.access.lists.state.AccessListState;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.acl.rev151001.access.lists.state.AccessListStateKey;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.acl.rev151001.access.lists.state.access.list.state.AclServiceFunctionClassifier;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.AclBase;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AccessListStateBuilder
implements Builder<AccessListState> {
    private String _aclName;
    private List<AclServiceFunctionClassifier> _aclServiceFunctionClassifier;
    private Class<? extends AclBase> _aclType;
    private AccessListStateKey _key;
    Map<Class<? extends Augmentation<AccessListState>>, Augmentation<AccessListState>> augmentation = Collections.emptyMap();

    public AccessListStateBuilder() {
    }

    public AccessListStateBuilder(AccessListState base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new AccessListStateKey(base.getAclName(), base.getAclType());
            this._aclName = base.getAclName();
            this._aclType = base.getAclType();
        } else {
            this._key = base.getKey();
            this._aclName = this._key.getAclName();
            this._aclType = this._key.getAclType();
        }
        this._aclServiceFunctionClassifier = base.getAclServiceFunctionClassifier();
        if (base instanceof AccessListStateImpl) {
            AccessListStateImpl impl = (AccessListStateImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<AccessListState>>, Augmentation<AccessListState>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AccessListState>>, Augmentation<AccessListState>>(casted.augmentations());
        }
    }

    public String getAclName() {
        return this._aclName;
    }

    public List<AclServiceFunctionClassifier> getAclServiceFunctionClassifier() {
        return this._aclServiceFunctionClassifier;
    }

    public Class<? extends AclBase> getAclType() {
        return this._aclType;
    }

    public AccessListStateKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<AccessListState>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public AccessListStateBuilder setAclName(String value) {
        this._aclName = value;
        return this;
    }

    public AccessListStateBuilder setAclServiceFunctionClassifier(List<AclServiceFunctionClassifier> value) {
        this._aclServiceFunctionClassifier = value;
        return this;
    }

    public AccessListStateBuilder setAclType(Class<? extends AclBase> value) {
        this._aclType = value;
        return this;
    }

    public AccessListStateBuilder setKey(AccessListStateKey value) {
        this._key = value;
        return this;
    }

    public AccessListStateBuilder addAugmentation(Class<? extends Augmentation<AccessListState>> augmentationType, Augmentation<AccessListState> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AccessListState>>, Augmentation<AccessListState>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AccessListStateBuilder removeAugmentation(Class<? extends Augmentation<AccessListState>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public AccessListState build() {
        return new AccessListStateImpl(this);
    }

    private static final class AccessListStateImpl
    implements AccessListState {
        private final String _aclName;
        private final List<AclServiceFunctionClassifier> _aclServiceFunctionClassifier;
        private final Class<? extends AclBase> _aclType;
        private final AccessListStateKey _key;
        private Map<Class<? extends Augmentation<AccessListState>>, Augmentation<AccessListState>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<AccessListState> getImplementedInterface() {
            return AccessListState.class;
        }

        private AccessListStateImpl(AccessListStateBuilder base) {
            if (base.getKey() == null) {
                this._key = new AccessListStateKey(base.getAclName(), base.getAclType());
                this._aclName = base.getAclName();
                this._aclType = base.getAclType();
            } else {
                this._key = base.getKey();
                this._aclName = this._key.getAclName();
                this._aclType = this._key.getAclType();
            }
            this._aclServiceFunctionClassifier = base.getAclServiceFunctionClassifier();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<AccessListState>>, Augmentation<AccessListState>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<AccessListState>>, Augmentation<AccessListState>>(base.augmentation);
                }
            }
        }

        @Override
        public String getAclName() {
            return this._aclName;
        }

        @Override
        public List<AclServiceFunctionClassifier> getAclServiceFunctionClassifier() {
            return this._aclServiceFunctionClassifier;
        }

        @Override
        public Class<? extends AclBase> getAclType() {
            return this._aclType;
        }

        @Override
        public AccessListStateKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<AccessListState>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._aclName);
            result = 31 * result + Objects.hashCode(this._aclServiceFunctionClassifier);
            result = 31 * result + Objects.hashCode(this._aclType);
            result = 31 * result + Objects.hashCode(this._key);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AccessListState.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            AccessListState other = (AccessListState)obj;
            if (!Objects.equals(this._aclName, other.getAclName())) {
                return false;
            }
            if (!Objects.equals(this._aclServiceFunctionClassifier, other.getAclServiceFunctionClassifier())) {
                return false;
            }
            if (!Objects.equals(this._aclType, other.getAclType())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AccessListStateImpl otherImpl = (AccessListStateImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<AccessListState>>, Augmentation<AccessListState>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "AccessListState [";
            StringBuilder builder = new StringBuilder(name);
            if (this._aclName != null) {
                builder.append("_aclName=");
                builder.append(this._aclName);
                builder.append(", ");
            }
            if (this._aclServiceFunctionClassifier != null) {
                builder.append("_aclServiceFunctionClassifier=");
                builder.append(this._aclServiceFunctionClassifier);
                builder.append(", ");
            }
            if (this._aclType != null) {
                builder.append("_aclType=");
                builder.append(this._aclType);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

