/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.service.path.id.rev150804.service.path.ids;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.service.path.id.rev150804.service.path.ids.ServicePathId;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.service.path.id.rev150804.service.path.ids.ServicePathIdKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServicePathIdBuilder
implements Builder<ServicePathId> {
    private ServicePathIdKey _key;
    private Long _pathIdBitarray;
    private Long _pathIdKey;
    Map<Class<? extends Augmentation<ServicePathId>>, Augmentation<ServicePathId>> augmentation = Collections.emptyMap();

    public ServicePathIdBuilder() {
    }

    public ServicePathIdBuilder(ServicePathId base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ServicePathIdKey(base.getPathIdKey());
            this._pathIdKey = base.getPathIdKey();
        } else {
            this._key = base.getKey();
            this._pathIdKey = this._key.getPathIdKey();
        }
        this._pathIdBitarray = base.getPathIdBitarray();
        if (base instanceof ServicePathIdImpl) {
            ServicePathIdImpl impl = (ServicePathIdImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ServicePathId>>, Augmentation<ServicePathId>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServicePathId>>, Augmentation<ServicePathId>>(casted.augmentations());
        }
    }

    public ServicePathIdKey getKey() {
        return this._key;
    }

    public Long getPathIdBitarray() {
        return this._pathIdBitarray;
    }

    public Long getPathIdKey() {
        return this._pathIdKey;
    }

    public <E extends Augmentation<ServicePathId>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ServicePathIdBuilder setKey(ServicePathIdKey value) {
        this._key = value;
        return this;
    }

    public ServicePathIdBuilder setPathIdBitarray(Long value) {
        this._pathIdBitarray = value;
        return this;
    }

    public ServicePathIdBuilder setPathIdKey(Long value) {
        this._pathIdKey = value;
        return this;
    }

    public ServicePathIdBuilder addAugmentation(Class<? extends Augmentation<ServicePathId>> augmentationType, Augmentation<ServicePathId> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServicePathId>>, Augmentation<ServicePathId>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ServicePathIdBuilder removeAugmentation(Class<? extends Augmentation<ServicePathId>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ServicePathId build() {
        return new ServicePathIdImpl(this);
    }

    private static final class ServicePathIdImpl
    implements ServicePathId {
        private final ServicePathIdKey _key;
        private final Long _pathIdBitarray;
        private final Long _pathIdKey;
        private Map<Class<? extends Augmentation<ServicePathId>>, Augmentation<ServicePathId>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ServicePathId> getImplementedInterface() {
            return ServicePathId.class;
        }

        private ServicePathIdImpl(ServicePathIdBuilder base) {
            if (base.getKey() == null) {
                this._key = new ServicePathIdKey(base.getPathIdKey());
                this._pathIdKey = base.getPathIdKey();
            } else {
                this._key = base.getKey();
                this._pathIdKey = this._key.getPathIdKey();
            }
            this._pathIdBitarray = base.getPathIdBitarray();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ServicePathId>>, Augmentation<ServicePathId>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ServicePathId>>, Augmentation<ServicePathId>>(base.augmentation);
                }
            }
        }

        @Override
        public ServicePathIdKey getKey() {
            return this._key;
        }

        @Override
        public Long getPathIdBitarray() {
            return this._pathIdBitarray;
        }

        @Override
        public Long getPathIdKey() {
            return this._pathIdKey;
        }

        public <E extends Augmentation<ServicePathId>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._pathIdBitarray);
            result = 31 * result + Objects.hashCode(this._pathIdKey);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ServicePathId.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ServicePathId other = (ServicePathId)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._pathIdBitarray, other.getPathIdBitarray())) {
                return false;
            }
            if (!Objects.equals(this._pathIdKey, other.getPathIdKey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServicePathIdImpl otherImpl = (ServicePathIdImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ServicePathId>>, Augmentation<ServicePathId>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ServicePathId [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._pathIdBitarray != null) {
                builder.append("_pathIdBitarray=");
                builder.append(this._pathIdBitarray);
                builder.append(", ");
            }
            if (this._pathIdKey != null) {
                builder.append("_pathIdKey=");
                builder.append(this._pathIdKey);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

