/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.service.path.id.rev150804;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.service.path.id.rev150804.GenerationAlgorithmEnum;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.service.path.id.rev150804.ServicePathIds;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.service.path.id.rev150804.service.path.ids.ServicePathId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServicePathIdsBuilder
implements Builder<ServicePathIds> {
    private Long _currentPathId;
    private GenerationAlgorithmEnum _generationAlgorithm;
    private List<ServicePathId> _servicePathId;
    Map<Class<? extends Augmentation<ServicePathIds>>, Augmentation<ServicePathIds>> augmentation = Collections.emptyMap();

    public ServicePathIdsBuilder() {
    }

    public ServicePathIdsBuilder(ServicePathIds base) {
        AugmentationHolder casted;
        this._currentPathId = base.getCurrentPathId();
        this._generationAlgorithm = base.getGenerationAlgorithm();
        this._servicePathId = base.getServicePathId();
        if (base instanceof ServicePathIdsImpl) {
            ServicePathIdsImpl impl = (ServicePathIdsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ServicePathIds>>, Augmentation<ServicePathIds>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServicePathIds>>, Augmentation<ServicePathIds>>(casted.augmentations());
        }
    }

    public Long getCurrentPathId() {
        return this._currentPathId;
    }

    public GenerationAlgorithmEnum getGenerationAlgorithm() {
        return this._generationAlgorithm;
    }

    public List<ServicePathId> getServicePathId() {
        return this._servicePathId;
    }

    public <E extends Augmentation<ServicePathIds>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkCurrentPathIdRange(long value) {
        if (value >= 0L && value <= 0x1000000L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..16777216]].", value));
    }

    public ServicePathIdsBuilder setCurrentPathId(Long value) {
        if (value != null) {
            ServicePathIdsBuilder.checkCurrentPathIdRange(value);
        }
        this._currentPathId = value;
        return this;
    }

    public ServicePathIdsBuilder setGenerationAlgorithm(GenerationAlgorithmEnum value) {
        this._generationAlgorithm = value;
        return this;
    }

    public ServicePathIdsBuilder setServicePathId(List<ServicePathId> value) {
        this._servicePathId = value;
        return this;
    }

    public ServicePathIdsBuilder addAugmentation(Class<? extends Augmentation<ServicePathIds>> augmentationType, Augmentation<ServicePathIds> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServicePathIds>>, Augmentation<ServicePathIds>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ServicePathIdsBuilder removeAugmentation(Class<? extends Augmentation<ServicePathIds>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ServicePathIds build() {
        return new ServicePathIdsImpl(this);
    }

    private static final class ServicePathIdsImpl
    implements ServicePathIds {
        private final Long _currentPathId;
        private final GenerationAlgorithmEnum _generationAlgorithm;
        private final List<ServicePathId> _servicePathId;
        private Map<Class<? extends Augmentation<ServicePathIds>>, Augmentation<ServicePathIds>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ServicePathIds> getImplementedInterface() {
            return ServicePathIds.class;
        }

        private ServicePathIdsImpl(ServicePathIdsBuilder base) {
            this._currentPathId = base.getCurrentPathId();
            this._generationAlgorithm = base.getGenerationAlgorithm();
            this._servicePathId = base.getServicePathId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ServicePathIds>>, Augmentation<ServicePathIds>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ServicePathIds>>, Augmentation<ServicePathIds>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getCurrentPathId() {
            return this._currentPathId;
        }

        @Override
        public GenerationAlgorithmEnum getGenerationAlgorithm() {
            return this._generationAlgorithm;
        }

        @Override
        public List<ServicePathId> getServicePathId() {
            return this._servicePathId;
        }

        public <E extends Augmentation<ServicePathIds>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._currentPathId);
            result = 31 * result + Objects.hashCode((Object)this._generationAlgorithm);
            result = 31 * result + Objects.hashCode(this._servicePathId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ServicePathIds.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ServicePathIds other = (ServicePathIds)obj;
            if (!Objects.equals(this._currentPathId, other.getCurrentPathId())) {
                return false;
            }
            if (!Objects.equals((Object)this._generationAlgorithm, (Object)other.getGenerationAlgorithm())) {
                return false;
            }
            if (!Objects.equals(this._servicePathId, other.getServicePathId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServicePathIdsImpl otherImpl = (ServicePathIdsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ServicePathIds>>, Augmentation<ServicePathIds>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ServicePathIds [";
            StringBuilder builder = new StringBuilder(name);
            if (this._currentPathId != null) {
                builder.append("_currentPathId=");
                builder.append(this._currentPathId);
                builder.append(", ");
            }
            if (this._generationAlgorithm != null) {
                builder.append("_generationAlgorithm=");
                builder.append((Object)this._generationAlgorithm);
                builder.append(", ");
            }
            if (this._servicePathId != null) {
                builder.append("_servicePathId=");
                builder.append(this._servicePathId);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

