/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.service.path.id.rev150804;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.service.path.id.rev150804.ReservePathIdRangeInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ReservePathIdRangeInputBuilder
implements Builder<ReservePathIdRangeInput> {
    private Long _pathIdEnd;
    private Long _pathIdStart;
    Map<Class<? extends Augmentation<ReservePathIdRangeInput>>, Augmentation<ReservePathIdRangeInput>> augmentation = Collections.emptyMap();

    public ReservePathIdRangeInputBuilder() {
    }

    public ReservePathIdRangeInputBuilder(ReservePathIdRangeInput base) {
        AugmentationHolder casted;
        this._pathIdEnd = base.getPathIdEnd();
        this._pathIdStart = base.getPathIdStart();
        if (base instanceof ReservePathIdRangeInputImpl) {
            ReservePathIdRangeInputImpl impl = (ReservePathIdRangeInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ReservePathIdRangeInput>>, Augmentation<ReservePathIdRangeInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ReservePathIdRangeInput>>, Augmentation<ReservePathIdRangeInput>>(casted.augmentations());
        }
    }

    public Long getPathIdEnd() {
        return this._pathIdEnd;
    }

    public Long getPathIdStart() {
        return this._pathIdStart;
    }

    public <E extends Augmentation<ReservePathIdRangeInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkPathIdEndRange(long value) {
        if (value >= 0L && value <= 0x1000000L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..16777216]].", value));
    }

    public ReservePathIdRangeInputBuilder setPathIdEnd(Long value) {
        if (value != null) {
            ReservePathIdRangeInputBuilder.checkPathIdEndRange(value);
        }
        this._pathIdEnd = value;
        return this;
    }

    private static void checkPathIdStartRange(long value) {
        if (value >= 0L && value <= 0x1000000L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..16777216]].", value));
    }

    public ReservePathIdRangeInputBuilder setPathIdStart(Long value) {
        if (value != null) {
            ReservePathIdRangeInputBuilder.checkPathIdStartRange(value);
        }
        this._pathIdStart = value;
        return this;
    }

    public ReservePathIdRangeInputBuilder addAugmentation(Class<? extends Augmentation<ReservePathIdRangeInput>> augmentationType, Augmentation<ReservePathIdRangeInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ReservePathIdRangeInput>>, Augmentation<ReservePathIdRangeInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ReservePathIdRangeInputBuilder removeAugmentation(Class<? extends Augmentation<ReservePathIdRangeInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ReservePathIdRangeInput build() {
        return new ReservePathIdRangeInputImpl(this);
    }

    private static final class ReservePathIdRangeInputImpl
    implements ReservePathIdRangeInput {
        private final Long _pathIdEnd;
        private final Long _pathIdStart;
        private Map<Class<? extends Augmentation<ReservePathIdRangeInput>>, Augmentation<ReservePathIdRangeInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ReservePathIdRangeInput> getImplementedInterface() {
            return ReservePathIdRangeInput.class;
        }

        private ReservePathIdRangeInputImpl(ReservePathIdRangeInputBuilder base) {
            this._pathIdEnd = base.getPathIdEnd();
            this._pathIdStart = base.getPathIdStart();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ReservePathIdRangeInput>>, Augmentation<ReservePathIdRangeInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ReservePathIdRangeInput>>, Augmentation<ReservePathIdRangeInput>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getPathIdEnd() {
            return this._pathIdEnd;
        }

        @Override
        public Long getPathIdStart() {
            return this._pathIdStart;
        }

        public <E extends Augmentation<ReservePathIdRangeInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._pathIdEnd);
            result = 31 * result + Objects.hashCode(this._pathIdStart);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ReservePathIdRangeInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ReservePathIdRangeInput other = (ReservePathIdRangeInput)obj;
            if (!Objects.equals(this._pathIdEnd, other.getPathIdEnd())) {
                return false;
            }
            if (!Objects.equals(this._pathIdStart, other.getPathIdStart())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ReservePathIdRangeInputImpl otherImpl = (ReservePathIdRangeInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ReservePathIdRangeInput>>, Augmentation<ReservePathIdRangeInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ReservePathIdRangeInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._pathIdEnd != null) {
                builder.append("_pathIdEnd=");
                builder.append(this._pathIdEnd);
                builder.append(", ");
            }
            if (this._pathIdStart != null) {
                builder.append("_pathIdStart=");
                builder.append(this._pathIdStart);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

