/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.service.path.id.rev150804;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.service.path.id.rev150804.DeletePathIdInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DeletePathIdInputBuilder
implements Builder<DeletePathIdInput> {
    private Long _pathId;
    Map<Class<? extends Augmentation<DeletePathIdInput>>, Augmentation<DeletePathIdInput>> augmentation = Collections.emptyMap();

    public DeletePathIdInputBuilder() {
    }

    public DeletePathIdInputBuilder(DeletePathIdInput base) {
        AugmentationHolder casted;
        this._pathId = base.getPathId();
        if (base instanceof DeletePathIdInputImpl) {
            DeletePathIdInputImpl impl = (DeletePathIdInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<DeletePathIdInput>>, Augmentation<DeletePathIdInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DeletePathIdInput>>, Augmentation<DeletePathIdInput>>(casted.augmentations());
        }
    }

    public Long getPathId() {
        return this._pathId;
    }

    public <E extends Augmentation<DeletePathIdInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkPathIdRange(long value) {
        if (value >= 0L && value <= 0x1000000L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..16777216]].", value));
    }

    public DeletePathIdInputBuilder setPathId(Long value) {
        if (value != null) {
            DeletePathIdInputBuilder.checkPathIdRange(value);
        }
        this._pathId = value;
        return this;
    }

    public DeletePathIdInputBuilder addAugmentation(Class<? extends Augmentation<DeletePathIdInput>> augmentationType, Augmentation<DeletePathIdInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DeletePathIdInput>>, Augmentation<DeletePathIdInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public DeletePathIdInputBuilder removeAugmentation(Class<? extends Augmentation<DeletePathIdInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public DeletePathIdInput build() {
        return new DeletePathIdInputImpl(this);
    }

    private static final class DeletePathIdInputImpl
    implements DeletePathIdInput {
        private final Long _pathId;
        private Map<Class<? extends Augmentation<DeletePathIdInput>>, Augmentation<DeletePathIdInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<DeletePathIdInput> getImplementedInterface() {
            return DeletePathIdInput.class;
        }

        private DeletePathIdInputImpl(DeletePathIdInputBuilder base) {
            this._pathId = base.getPathId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<DeletePathIdInput>>, Augmentation<DeletePathIdInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<DeletePathIdInput>>, Augmentation<DeletePathIdInput>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getPathId() {
            return this._pathId;
        }

        public <E extends Augmentation<DeletePathIdInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._pathId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DeletePathIdInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DeletePathIdInput other = (DeletePathIdInput)obj;
            if (!Objects.equals(this._pathId, other.getPathId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                DeletePathIdInputImpl otherImpl = (DeletePathIdInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<DeletePathIdInput>>, Augmentation<DeletePathIdInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "DeletePathIdInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._pathId != null) {
                builder.append("_pathId=");
                builder.append(this._pathId);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

