/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.service.path.id.rev150804;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.service.path.id.rev150804.AllocatePathIdInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AllocatePathIdInputBuilder
implements Builder<AllocatePathIdInput> {
    private Long _pathId;
    Map<Class<? extends Augmentation<AllocatePathIdInput>>, Augmentation<AllocatePathIdInput>> augmentation = Collections.emptyMap();

    public AllocatePathIdInputBuilder() {
    }

    public AllocatePathIdInputBuilder(AllocatePathIdInput base) {
        AugmentationHolder casted;
        this._pathId = base.getPathId();
        if (base instanceof AllocatePathIdInputImpl) {
            AllocatePathIdInputImpl impl = (AllocatePathIdInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<AllocatePathIdInput>>, Augmentation<AllocatePathIdInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AllocatePathIdInput>>, Augmentation<AllocatePathIdInput>>(casted.augmentations());
        }
    }

    public Long getPathId() {
        return this._pathId;
    }

    public <E extends Augmentation<AllocatePathIdInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkPathIdRange(long value) {
        if (value >= 0L && value <= 0x1000000L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..16777216]].", value));
    }

    public AllocatePathIdInputBuilder setPathId(Long value) {
        if (value != null) {
            AllocatePathIdInputBuilder.checkPathIdRange(value);
        }
        this._pathId = value;
        return this;
    }

    public AllocatePathIdInputBuilder addAugmentation(Class<? extends Augmentation<AllocatePathIdInput>> augmentationType, Augmentation<AllocatePathIdInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AllocatePathIdInput>>, Augmentation<AllocatePathIdInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AllocatePathIdInputBuilder removeAugmentation(Class<? extends Augmentation<AllocatePathIdInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public AllocatePathIdInput build() {
        return new AllocatePathIdInputImpl(this);
    }

    private static final class AllocatePathIdInputImpl
    implements AllocatePathIdInput {
        private final Long _pathId;
        private Map<Class<? extends Augmentation<AllocatePathIdInput>>, Augmentation<AllocatePathIdInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<AllocatePathIdInput> getImplementedInterface() {
            return AllocatePathIdInput.class;
        }

        private AllocatePathIdInputImpl(AllocatePathIdInputBuilder base) {
            this._pathId = base.getPathId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<AllocatePathIdInput>>, Augmentation<AllocatePathIdInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<AllocatePathIdInput>>, Augmentation<AllocatePathIdInput>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getPathId() {
            return this._pathId;
        }

        public <E extends Augmentation<AllocatePathIdInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._pathId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AllocatePathIdInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            AllocatePathIdInput other = (AllocatePathIdInput)obj;
            if (!Objects.equals(this._pathId, other.getPathId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AllocatePathIdInputImpl otherImpl = (AllocatePathIdInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<AllocatePathIdInput>>, Augmentation<AllocatePathIdInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "AllocatePathIdInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._pathId != null) {
                builder.append("_pathId=");
                builder.append(this._pathId);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

