/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.rsp.manager.data.renderer.rendered.service.path;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.RspHopInfo;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.rsp.hop.info.NextHop;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.rsp.hop.info.ServiceFunctionData;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.rsp.hop.info.ServiceFunctionForwarderData;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.rsp.manager.data.renderer.rendered.service.path.HopToConfigure;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.rsp.manager.data.renderer.rendered.service.path.HopToConfigureKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class HopToConfigureBuilder
implements Builder<HopToConfigure> {
    private Short _hopNumber;
    private HopToConfigureKey _key;
    private NextHop _nextHop;
    private ServiceFunctionData _serviceFunctionData;
    private ServiceFunctionForwarderData _serviceFunctionForwarderData;
    private Short _serviceIndex;
    Map<Class<? extends Augmentation<HopToConfigure>>, Augmentation<HopToConfigure>> augmentation = Collections.emptyMap();

    public HopToConfigureBuilder() {
    }

    public HopToConfigureBuilder(RspHopInfo arg) {
        this._serviceFunctionData = arg.getServiceFunctionData();
        this._serviceFunctionForwarderData = arg.getServiceFunctionForwarderData();
        this._serviceIndex = arg.getServiceIndex();
        this._nextHop = arg.getNextHop();
    }

    public HopToConfigureBuilder(HopToConfigure base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new HopToConfigureKey(base.getHopNumber());
            this._hopNumber = base.getHopNumber();
        } else {
            this._key = base.getKey();
            this._hopNumber = this._key.getHopNumber();
        }
        this._nextHop = base.getNextHop();
        this._serviceFunctionData = base.getServiceFunctionData();
        this._serviceFunctionForwarderData = base.getServiceFunctionForwarderData();
        this._serviceIndex = base.getServiceIndex();
        if (base instanceof HopToConfigureImpl) {
            HopToConfigureImpl impl = (HopToConfigureImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<HopToConfigure>>, Augmentation<HopToConfigure>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<HopToConfigure>>, Augmentation<HopToConfigure>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RspHopInfo) {
            this._serviceFunctionData = ((RspHopInfo)arg).getServiceFunctionData();
            this._serviceFunctionForwarderData = ((RspHopInfo)arg).getServiceFunctionForwarderData();
            this._serviceIndex = ((RspHopInfo)arg).getServiceIndex();
            this._nextHop = ((RspHopInfo)arg).getNextHop();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.RspHopInfo] \nbut was: " + arg);
        }
    }

    public Short getHopNumber() {
        return this._hopNumber;
    }

    public HopToConfigureKey getKey() {
        return this._key;
    }

    public NextHop getNextHop() {
        return this._nextHop;
    }

    public ServiceFunctionData getServiceFunctionData() {
        return this._serviceFunctionData;
    }

    public ServiceFunctionForwarderData getServiceFunctionForwarderData() {
        return this._serviceFunctionForwarderData;
    }

    public Short getServiceIndex() {
        return this._serviceIndex;
    }

    public <E extends Augmentation<HopToConfigure>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkHopNumberRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public HopToConfigureBuilder setHopNumber(Short value) {
        if (value != null) {
            HopToConfigureBuilder.checkHopNumberRange(value);
        }
        this._hopNumber = value;
        return this;
    }

    public HopToConfigureBuilder setKey(HopToConfigureKey value) {
        this._key = value;
        return this;
    }

    public HopToConfigureBuilder setNextHop(NextHop value) {
        this._nextHop = value;
        return this;
    }

    public HopToConfigureBuilder setServiceFunctionData(ServiceFunctionData value) {
        this._serviceFunctionData = value;
        return this;
    }

    public HopToConfigureBuilder setServiceFunctionForwarderData(ServiceFunctionForwarderData value) {
        this._serviceFunctionForwarderData = value;
        return this;
    }

    private static void checkServiceIndexRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public HopToConfigureBuilder setServiceIndex(Short value) {
        if (value != null) {
            HopToConfigureBuilder.checkServiceIndexRange(value);
        }
        this._serviceIndex = value;
        return this;
    }

    public HopToConfigureBuilder addAugmentation(Class<? extends Augmentation<HopToConfigure>> augmentationType, Augmentation<HopToConfigure> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<HopToConfigure>>, Augmentation<HopToConfigure>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public HopToConfigureBuilder removeAugmentation(Class<? extends Augmentation<HopToConfigure>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public HopToConfigure build() {
        return new HopToConfigureImpl(this);
    }

    private static final class HopToConfigureImpl
    implements HopToConfigure {
        private final Short _hopNumber;
        private final HopToConfigureKey _key;
        private final NextHop _nextHop;
        private final ServiceFunctionData _serviceFunctionData;
        private final ServiceFunctionForwarderData _serviceFunctionForwarderData;
        private final Short _serviceIndex;
        private Map<Class<? extends Augmentation<HopToConfigure>>, Augmentation<HopToConfigure>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<HopToConfigure> getImplementedInterface() {
            return HopToConfigure.class;
        }

        private HopToConfigureImpl(HopToConfigureBuilder base) {
            if (base.getKey() == null) {
                this._key = new HopToConfigureKey(base.getHopNumber());
                this._hopNumber = base.getHopNumber();
            } else {
                this._key = base.getKey();
                this._hopNumber = this._key.getHopNumber();
            }
            this._nextHop = base.getNextHop();
            this._serviceFunctionData = base.getServiceFunctionData();
            this._serviceFunctionForwarderData = base.getServiceFunctionForwarderData();
            this._serviceIndex = base.getServiceIndex();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<HopToConfigure>>, Augmentation<HopToConfigure>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<HopToConfigure>>, Augmentation<HopToConfigure>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getHopNumber() {
            return this._hopNumber;
        }

        @Override
        public HopToConfigureKey getKey() {
            return this._key;
        }

        @Override
        public NextHop getNextHop() {
            return this._nextHop;
        }

        @Override
        public ServiceFunctionData getServiceFunctionData() {
            return this._serviceFunctionData;
        }

        @Override
        public ServiceFunctionForwarderData getServiceFunctionForwarderData() {
            return this._serviceFunctionForwarderData;
        }

        @Override
        public Short getServiceIndex() {
            return this._serviceIndex;
        }

        public <E extends Augmentation<HopToConfigure>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._hopNumber);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._nextHop);
            result = 31 * result + Objects.hashCode(this._serviceFunctionData);
            result = 31 * result + Objects.hashCode(this._serviceFunctionForwarderData);
            result = 31 * result + Objects.hashCode(this._serviceIndex);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!HopToConfigure.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            HopToConfigure other = (HopToConfigure)obj;
            if (!Objects.equals(this._hopNumber, other.getHopNumber())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._nextHop, other.getNextHop())) {
                return false;
            }
            if (!Objects.equals(this._serviceFunctionData, other.getServiceFunctionData())) {
                return false;
            }
            if (!Objects.equals(this._serviceFunctionForwarderData, other.getServiceFunctionForwarderData())) {
                return false;
            }
            if (!Objects.equals(this._serviceIndex, other.getServiceIndex())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                HopToConfigureImpl otherImpl = (HopToConfigureImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<HopToConfigure>>, Augmentation<HopToConfigure>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "HopToConfigure [";
            StringBuilder builder = new StringBuilder(name);
            if (this._hopNumber != null) {
                builder.append("_hopNumber=");
                builder.append(this._hopNumber);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._nextHop != null) {
                builder.append("_nextHop=");
                builder.append(this._nextHop);
                builder.append(", ");
            }
            if (this._serviceFunctionData != null) {
                builder.append("_serviceFunctionData=");
                builder.append(this._serviceFunctionData);
                builder.append(", ");
            }
            if (this._serviceFunctionForwarderData != null) {
                builder.append("_serviceFunctionForwarderData=");
                builder.append(this._serviceFunctionForwarderData);
                builder.append(", ");
            }
            if (this._serviceIndex != null) {
                builder.append("_serviceIndex=");
                builder.append(this._serviceIndex);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

