/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.rsp.manager.data.renderer;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.rsp.manager.data.renderer.RenderedServicePath;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.rsp.manager.data.renderer.RenderedServicePathKey;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.rsp.manager.data.renderer.rendered.service.path.HopToConfigure;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.RspName;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RenderedServicePathBuilder
implements Builder<RenderedServicePath> {
    private List<HopToConfigure> _hopToConfigure;
    private RenderedServicePathKey _key;
    private Long _pathId;
    private RspName _rspName;
    Map<Class<? extends Augmentation<RenderedServicePath>>, Augmentation<RenderedServicePath>> augmentation = Collections.emptyMap();

    public RenderedServicePathBuilder() {
    }

    public RenderedServicePathBuilder(RenderedServicePath base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new RenderedServicePathKey(base.getRspName());
            this._rspName = base.getRspName();
        } else {
            this._key = base.getKey();
            this._rspName = this._key.getRspName();
        }
        this._hopToConfigure = base.getHopToConfigure();
        this._pathId = base.getPathId();
        if (base instanceof RenderedServicePathImpl) {
            RenderedServicePathImpl impl = (RenderedServicePathImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<RenderedServicePath>>, Augmentation<RenderedServicePath>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RenderedServicePath>>, Augmentation<RenderedServicePath>>(casted.augmentations());
        }
    }

    public List<HopToConfigure> getHopToConfigure() {
        return this._hopToConfigure;
    }

    public RenderedServicePathKey getKey() {
        return this._key;
    }

    public Long getPathId() {
        return this._pathId;
    }

    public RspName getRspName() {
        return this._rspName;
    }

    public <E extends Augmentation<RenderedServicePath>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public RenderedServicePathBuilder setHopToConfigure(List<HopToConfigure> value) {
        this._hopToConfigure = value;
        return this;
    }

    public RenderedServicePathBuilder setKey(RenderedServicePathKey value) {
        this._key = value;
        return this;
    }

    private static void checkPathIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public RenderedServicePathBuilder setPathId(Long value) {
        if (value != null) {
            RenderedServicePathBuilder.checkPathIdRange(value);
        }
        this._pathId = value;
        return this;
    }

    public RenderedServicePathBuilder setRspName(RspName value) {
        this._rspName = value;
        return this;
    }

    public RenderedServicePathBuilder addAugmentation(Class<? extends Augmentation<RenderedServicePath>> augmentationType, Augmentation<RenderedServicePath> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RenderedServicePath>>, Augmentation<RenderedServicePath>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RenderedServicePathBuilder removeAugmentation(Class<? extends Augmentation<RenderedServicePath>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RenderedServicePath build() {
        return new RenderedServicePathImpl(this);
    }

    private static final class RenderedServicePathImpl
    implements RenderedServicePath {
        private final List<HopToConfigure> _hopToConfigure;
        private final RenderedServicePathKey _key;
        private final Long _pathId;
        private final RspName _rspName;
        private Map<Class<? extends Augmentation<RenderedServicePath>>, Augmentation<RenderedServicePath>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<RenderedServicePath> getImplementedInterface() {
            return RenderedServicePath.class;
        }

        private RenderedServicePathImpl(RenderedServicePathBuilder base) {
            if (base.getKey() == null) {
                this._key = new RenderedServicePathKey(base.getRspName());
                this._rspName = base.getRspName();
            } else {
                this._key = base.getKey();
                this._rspName = this._key.getRspName();
            }
            this._hopToConfigure = base.getHopToConfigure();
            this._pathId = base.getPathId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<RenderedServicePath>>, Augmentation<RenderedServicePath>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<RenderedServicePath>>, Augmentation<RenderedServicePath>>(base.augmentation);
                }
            }
        }

        @Override
        public List<HopToConfigure> getHopToConfigure() {
            return this._hopToConfigure;
        }

        @Override
        public RenderedServicePathKey getKey() {
            return this._key;
        }

        @Override
        public Long getPathId() {
            return this._pathId;
        }

        @Override
        public RspName getRspName() {
            return this._rspName;
        }

        public <E extends Augmentation<RenderedServicePath>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._hopToConfigure);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._pathId);
            result = 31 * result + Objects.hashCode(this._rspName);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RenderedServicePath.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            RenderedServicePath other = (RenderedServicePath)obj;
            if (!Objects.equals(this._hopToConfigure, other.getHopToConfigure())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._pathId, other.getPathId())) {
                return false;
            }
            if (!Objects.equals(this._rspName, other.getRspName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RenderedServicePathImpl otherImpl = (RenderedServicePathImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<RenderedServicePath>>, Augmentation<RenderedServicePath>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "RenderedServicePath [";
            StringBuilder builder = new StringBuilder(name);
            if (this._hopToConfigure != null) {
                builder.append("_hopToConfigure=");
                builder.append(this._hopToConfigure);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._pathId != null) {
                builder.append("_pathId=");
                builder.append(this._pathId);
                builder.append(", ");
            }
            if (this._rspName != null) {
                builder.append("_rspName=");
                builder.append(this._rspName);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

