/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.rsp.manager.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.rsp.manager.data.Renderer;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.rsp.manager.data.RendererKey;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.rsp.manager.data.renderer.RenderedServicePath;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.RendererName;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RendererBuilder
implements Builder<Renderer> {
    private RendererKey _key;
    private List<RenderedServicePath> _renderedServicePath;
    private RendererName _rendererName;
    Map<Class<? extends Augmentation<Renderer>>, Augmentation<Renderer>> augmentation = Collections.emptyMap();

    public RendererBuilder() {
    }

    public RendererBuilder(Renderer base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new RendererKey(base.getRendererName());
            this._rendererName = base.getRendererName();
        } else {
            this._key = base.getKey();
            this._rendererName = this._key.getRendererName();
        }
        this._renderedServicePath = base.getRenderedServicePath();
        if (base instanceof RendererImpl) {
            RendererImpl impl = (RendererImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Renderer>>, Augmentation<Renderer>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Renderer>>, Augmentation<Renderer>>(casted.augmentations());
        }
    }

    public RendererKey getKey() {
        return this._key;
    }

    public List<RenderedServicePath> getRenderedServicePath() {
        return this._renderedServicePath;
    }

    public RendererName getRendererName() {
        return this._rendererName;
    }

    public <E extends Augmentation<Renderer>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public RendererBuilder setKey(RendererKey value) {
        this._key = value;
        return this;
    }

    public RendererBuilder setRenderedServicePath(List<RenderedServicePath> value) {
        this._renderedServicePath = value;
        return this;
    }

    public RendererBuilder setRendererName(RendererName value) {
        this._rendererName = value;
        return this;
    }

    public RendererBuilder addAugmentation(Class<? extends Augmentation<Renderer>> augmentationType, Augmentation<Renderer> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Renderer>>, Augmentation<Renderer>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RendererBuilder removeAugmentation(Class<? extends Augmentation<Renderer>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Renderer build() {
        return new RendererImpl(this);
    }

    private static final class RendererImpl
    implements Renderer {
        private final RendererKey _key;
        private final List<RenderedServicePath> _renderedServicePath;
        private final RendererName _rendererName;
        private Map<Class<? extends Augmentation<Renderer>>, Augmentation<Renderer>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Renderer> getImplementedInterface() {
            return Renderer.class;
        }

        private RendererImpl(RendererBuilder base) {
            if (base.getKey() == null) {
                this._key = new RendererKey(base.getRendererName());
                this._rendererName = base.getRendererName();
            } else {
                this._key = base.getKey();
                this._rendererName = this._key.getRendererName();
            }
            this._renderedServicePath = base.getRenderedServicePath();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Renderer>>, Augmentation<Renderer>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Renderer>>, Augmentation<Renderer>>(base.augmentation);
                }
            }
        }

        @Override
        public RendererKey getKey() {
            return this._key;
        }

        @Override
        public List<RenderedServicePath> getRenderedServicePath() {
            return this._renderedServicePath;
        }

        @Override
        public RendererName getRendererName() {
            return this._rendererName;
        }

        public <E extends Augmentation<Renderer>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._renderedServicePath);
            result = 31 * result + Objects.hashCode(this._rendererName);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Renderer.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Renderer other = (Renderer)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._renderedServicePath, other.getRenderedServicePath())) {
                return false;
            }
            if (!Objects.equals(this._rendererName, other.getRendererName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RendererImpl otherImpl = (RendererImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Renderer>>, Augmentation<Renderer>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Renderer [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._renderedServicePath != null) {
                builder.append("_renderedServicePath=");
                builder.append(this._renderedServicePath);
                builder.append(", ");
            }
            if (this._rendererName != null) {
                builder.append("_rendererName=");
                builder.append(this._rendererName);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

