/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.rsp.hop.info;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.rsp.hop.info.ServiceFunctionData;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SfName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SftTypeName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sf.rev140701.ServiceFunctionBase;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sf.rev140701.service.function.base.SfDataPlaneLocator;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServiceFunctionDataBuilder
implements Builder<ServiceFunctionData> {
    private IpAddress _ipMgmtAddress;
    private SfName _name;
    private List<SfDataPlaneLocator> _sfDataPlaneLocator;
    private SftTypeName _type;
    private Boolean _oneChainOnly;
    Map<Class<? extends Augmentation<ServiceFunctionData>>, Augmentation<ServiceFunctionData>> augmentation = Collections.emptyMap();

    public ServiceFunctionDataBuilder() {
    }

    public ServiceFunctionDataBuilder(ServiceFunctionBase arg) {
        this._name = arg.getName();
        this._type = arg.getType();
        this._ipMgmtAddress = arg.getIpMgmtAddress();
        this._oneChainOnly = arg.isOneChainOnly();
        this._sfDataPlaneLocator = arg.getSfDataPlaneLocator();
    }

    public ServiceFunctionDataBuilder(ServiceFunctionData base) {
        AugmentationHolder casted;
        this._ipMgmtAddress = base.getIpMgmtAddress();
        this._name = base.getName();
        this._sfDataPlaneLocator = base.getSfDataPlaneLocator();
        this._type = base.getType();
        this._oneChainOnly = base.isOneChainOnly();
        if (base instanceof ServiceFunctionDataImpl) {
            ServiceFunctionDataImpl impl = (ServiceFunctionDataImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionData>>, Augmentation<ServiceFunctionData>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionData>>, Augmentation<ServiceFunctionData>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ServiceFunctionBase) {
            this._name = ((ServiceFunctionBase)arg).getName();
            this._type = ((ServiceFunctionBase)arg).getType();
            this._ipMgmtAddress = ((ServiceFunctionBase)arg).getIpMgmtAddress();
            this._oneChainOnly = ((ServiceFunctionBase)arg).isOneChainOnly();
            this._sfDataPlaneLocator = ((ServiceFunctionBase)arg).getSfDataPlaneLocator();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sf.rev140701.ServiceFunctionBase] \nbut was: " + arg);
        }
    }

    public IpAddress getIpMgmtAddress() {
        return this._ipMgmtAddress;
    }

    public SfName getName() {
        return this._name;
    }

    public List<SfDataPlaneLocator> getSfDataPlaneLocator() {
        return this._sfDataPlaneLocator;
    }

    public SftTypeName getType() {
        return this._type;
    }

    public Boolean isOneChainOnly() {
        return this._oneChainOnly;
    }

    public <E extends Augmentation<ServiceFunctionData>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ServiceFunctionDataBuilder setIpMgmtAddress(IpAddress value) {
        this._ipMgmtAddress = value;
        return this;
    }

    public ServiceFunctionDataBuilder setName(SfName value) {
        this._name = value;
        return this;
    }

    public ServiceFunctionDataBuilder setSfDataPlaneLocator(List<SfDataPlaneLocator> value) {
        this._sfDataPlaneLocator = value;
        return this;
    }

    public ServiceFunctionDataBuilder setType(SftTypeName value) {
        this._type = value;
        return this;
    }

    public ServiceFunctionDataBuilder setOneChainOnly(Boolean value) {
        this._oneChainOnly = value;
        return this;
    }

    public ServiceFunctionDataBuilder addAugmentation(Class<? extends Augmentation<ServiceFunctionData>> augmentationType, Augmentation<ServiceFunctionData> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionData>>, Augmentation<ServiceFunctionData>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ServiceFunctionDataBuilder removeAugmentation(Class<? extends Augmentation<ServiceFunctionData>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ServiceFunctionData build() {
        return new ServiceFunctionDataImpl(this);
    }

    private static final class ServiceFunctionDataImpl
    implements ServiceFunctionData {
        private final IpAddress _ipMgmtAddress;
        private final SfName _name;
        private final List<SfDataPlaneLocator> _sfDataPlaneLocator;
        private final SftTypeName _type;
        private final Boolean _oneChainOnly;
        private Map<Class<? extends Augmentation<ServiceFunctionData>>, Augmentation<ServiceFunctionData>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ServiceFunctionData> getImplementedInterface() {
            return ServiceFunctionData.class;
        }

        private ServiceFunctionDataImpl(ServiceFunctionDataBuilder base) {
            this._ipMgmtAddress = base.getIpMgmtAddress();
            this._name = base.getName();
            this._sfDataPlaneLocator = base.getSfDataPlaneLocator();
            this._type = base.getType();
            this._oneChainOnly = base.isOneChainOnly();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ServiceFunctionData>>, Augmentation<ServiceFunctionData>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionData>>, Augmentation<ServiceFunctionData>>(base.augmentation);
                }
            }
        }

        @Override
        public IpAddress getIpMgmtAddress() {
            return this._ipMgmtAddress;
        }

        @Override
        public SfName getName() {
            return this._name;
        }

        @Override
        public List<SfDataPlaneLocator> getSfDataPlaneLocator() {
            return this._sfDataPlaneLocator;
        }

        @Override
        public SftTypeName getType() {
            return this._type;
        }

        @Override
        public Boolean isOneChainOnly() {
            return this._oneChainOnly;
        }

        public <E extends Augmentation<ServiceFunctionData>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ipMgmtAddress);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._sfDataPlaneLocator);
            result = 31 * result + Objects.hashCode(this._type);
            result = 31 * result + Objects.hashCode(this._oneChainOnly);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ServiceFunctionData.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ServiceFunctionData other = (ServiceFunctionData)obj;
            if (!Objects.equals(this._ipMgmtAddress, other.getIpMgmtAddress())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._sfDataPlaneLocator, other.getSfDataPlaneLocator())) {
                return false;
            }
            if (!Objects.equals(this._type, other.getType())) {
                return false;
            }
            if (!Objects.equals(this._oneChainOnly, other.isOneChainOnly())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServiceFunctionDataImpl otherImpl = (ServiceFunctionDataImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ServiceFunctionData>>, Augmentation<ServiceFunctionData>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ServiceFunctionData [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ipMgmtAddress != null) {
                builder.append("_ipMgmtAddress=");
                builder.append(this._ipMgmtAddress);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._sfDataPlaneLocator != null) {
                builder.append("_sfDataPlaneLocator=");
                builder.append(this._sfDataPlaneLocator);
                builder.append(", ");
            }
            if (this._type != null) {
                builder.append("_type=");
                builder.append(this._type);
                builder.append(", ");
            }
            if (this._oneChainOnly != null) {
                builder.append("_oneChainOnly=");
                builder.append(this._oneChainOnly);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

