/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.renderer.path.states;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.renderer.path.states.RendererPathState;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.renderer.path.states.RendererPathStateKey;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.renderer.path.states.renderer.path.state.ConfiguredRenderedPaths;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.RendererName;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RendererPathStateBuilder
implements Builder<RendererPathState> {
    private ConfiguredRenderedPaths _configuredRenderedPaths;
    private RendererPathStateKey _key;
    private RendererName _rendererName;
    Map<Class<? extends Augmentation<RendererPathState>>, Augmentation<RendererPathState>> augmentation = Collections.emptyMap();

    public RendererPathStateBuilder() {
    }

    public RendererPathStateBuilder(RendererPathState base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new RendererPathStateKey(base.getRendererName());
            this._rendererName = base.getRendererName();
        } else {
            this._key = base.getKey();
            this._rendererName = this._key.getRendererName();
        }
        this._configuredRenderedPaths = base.getConfiguredRenderedPaths();
        if (base instanceof RendererPathStateImpl) {
            RendererPathStateImpl impl = (RendererPathStateImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<RendererPathState>>, Augmentation<RendererPathState>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RendererPathState>>, Augmentation<RendererPathState>>(casted.augmentations());
        }
    }

    public ConfiguredRenderedPaths getConfiguredRenderedPaths() {
        return this._configuredRenderedPaths;
    }

    public RendererPathStateKey getKey() {
        return this._key;
    }

    public RendererName getRendererName() {
        return this._rendererName;
    }

    public <E extends Augmentation<RendererPathState>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public RendererPathStateBuilder setConfiguredRenderedPaths(ConfiguredRenderedPaths value) {
        this._configuredRenderedPaths = value;
        return this;
    }

    public RendererPathStateBuilder setKey(RendererPathStateKey value) {
        this._key = value;
        return this;
    }

    public RendererPathStateBuilder setRendererName(RendererName value) {
        this._rendererName = value;
        return this;
    }

    public RendererPathStateBuilder addAugmentation(Class<? extends Augmentation<RendererPathState>> augmentationType, Augmentation<RendererPathState> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RendererPathState>>, Augmentation<RendererPathState>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RendererPathStateBuilder removeAugmentation(Class<? extends Augmentation<RendererPathState>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RendererPathState build() {
        return new RendererPathStateImpl(this);
    }

    private static final class RendererPathStateImpl
    implements RendererPathState {
        private final ConfiguredRenderedPaths _configuredRenderedPaths;
        private final RendererPathStateKey _key;
        private final RendererName _rendererName;
        private Map<Class<? extends Augmentation<RendererPathState>>, Augmentation<RendererPathState>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<RendererPathState> getImplementedInterface() {
            return RendererPathState.class;
        }

        private RendererPathStateImpl(RendererPathStateBuilder base) {
            if (base.getKey() == null) {
                this._key = new RendererPathStateKey(base.getRendererName());
                this._rendererName = base.getRendererName();
            } else {
                this._key = base.getKey();
                this._rendererName = this._key.getRendererName();
            }
            this._configuredRenderedPaths = base.getConfiguredRenderedPaths();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<RendererPathState>>, Augmentation<RendererPathState>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<RendererPathState>>, Augmentation<RendererPathState>>(base.augmentation);
                }
            }
        }

        @Override
        public ConfiguredRenderedPaths getConfiguredRenderedPaths() {
            return this._configuredRenderedPaths;
        }

        @Override
        public RendererPathStateKey getKey() {
            return this._key;
        }

        @Override
        public RendererName getRendererName() {
            return this._rendererName;
        }

        public <E extends Augmentation<RendererPathState>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._configuredRenderedPaths);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._rendererName);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RendererPathState.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            RendererPathState other = (RendererPathState)obj;
            if (!Objects.equals(this._configuredRenderedPaths, other.getConfiguredRenderedPaths())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._rendererName, other.getRendererName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RendererPathStateImpl otherImpl = (RendererPathStateImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<RendererPathState>>, Augmentation<RendererPathState>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "RendererPathState [";
            StringBuilder builder = new StringBuilder(name);
            if (this._configuredRenderedPaths != null) {
                builder.append("_configuredRenderedPaths=");
                builder.append(this._configuredRenderedPaths);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._rendererName != null) {
                builder.append("_rendererName=");
                builder.append(this._rendererName);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

