/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.managed.nodes.by.renderer.renderer.nodes.nodes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.managed.nodes.by.renderer.renderer.nodes.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.managed.nodes.by.renderer.renderer.nodes.nodes.NodeKey;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SnName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NodeBuilder
implements Builder<Node> {
    private IpAddress _ipMgmtAddress;
    private NodeKey _key;
    private SnName _nodeName;
    Map<Class<? extends Augmentation<Node>>, Augmentation<Node>> augmentation = Collections.emptyMap();

    public NodeBuilder() {
    }

    public NodeBuilder(Node base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new NodeKey(base.getNodeName());
            this._nodeName = base.getNodeName();
        } else {
            this._key = base.getKey();
            this._nodeName = this._key.getNodeName();
        }
        this._ipMgmtAddress = base.getIpMgmtAddress();
        if (base instanceof NodeImpl) {
            NodeImpl impl = (NodeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Node>>, Augmentation<Node>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Node>>, Augmentation<Node>>(casted.augmentations());
        }
    }

    public IpAddress getIpMgmtAddress() {
        return this._ipMgmtAddress;
    }

    public NodeKey getKey() {
        return this._key;
    }

    public SnName getNodeName() {
        return this._nodeName;
    }

    public <E extends Augmentation<Node>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NodeBuilder setIpMgmtAddress(IpAddress value) {
        this._ipMgmtAddress = value;
        return this;
    }

    public NodeBuilder setKey(NodeKey value) {
        this._key = value;
        return this;
    }

    public NodeBuilder setNodeName(SnName value) {
        this._nodeName = value;
        return this;
    }

    public NodeBuilder addAugmentation(Class<? extends Augmentation<Node>> augmentationType, Augmentation<Node> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Node>>, Augmentation<Node>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NodeBuilder removeAugmentation(Class<? extends Augmentation<Node>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Node build() {
        return new NodeImpl(this);
    }

    private static final class NodeImpl
    implements Node {
        private final IpAddress _ipMgmtAddress;
        private final NodeKey _key;
        private final SnName _nodeName;
        private Map<Class<? extends Augmentation<Node>>, Augmentation<Node>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Node> getImplementedInterface() {
            return Node.class;
        }

        private NodeImpl(NodeBuilder base) {
            if (base.getKey() == null) {
                this._key = new NodeKey(base.getNodeName());
                this._nodeName = base.getNodeName();
            } else {
                this._key = base.getKey();
                this._nodeName = this._key.getNodeName();
            }
            this._ipMgmtAddress = base.getIpMgmtAddress();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Node>>, Augmentation<Node>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Node>>, Augmentation<Node>>(base.augmentation);
                }
            }
        }

        @Override
        public IpAddress getIpMgmtAddress() {
            return this._ipMgmtAddress;
        }

        @Override
        public NodeKey getKey() {
            return this._key;
        }

        @Override
        public SnName getNodeName() {
            return this._nodeName;
        }

        public <E extends Augmentation<Node>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ipMgmtAddress);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._nodeName);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Node.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Node other = (Node)obj;
            if (!Objects.equals(this._ipMgmtAddress, other.getIpMgmtAddress())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._nodeName, other.getNodeName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NodeImpl otherImpl = (NodeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Node>>, Augmentation<Node>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Node [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ipMgmtAddress != null) {
                builder.append("_ipMgmtAddress=");
                builder.append(this._ipMgmtAddress);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._nodeName != null) {
                builder.append("_nodeName=");
                builder.append(this._nodeName);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

