/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.managed.nodes.by.renderer.renderer.nodes;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.managed.nodes.by.renderer.renderer.nodes.Nodes;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.rsp.manager.rev160421.managed.nodes.by.renderer.renderer.nodes.nodes.Node;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NodesBuilder
implements Builder<Nodes> {
    private List<Node> _node;
    Map<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>> augmentation = Collections.emptyMap();

    public NodesBuilder() {
    }

    public NodesBuilder(Nodes base) {
        AugmentationHolder casted;
        this._node = base.getNode();
        if (base instanceof NodesImpl) {
            NodesImpl impl = (NodesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>>(casted.augmentations());
        }
    }

    public List<Node> getNode() {
        return this._node;
    }

    public <E extends Augmentation<Nodes>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NodesBuilder setNode(List<Node> value) {
        this._node = value;
        return this;
    }

    public NodesBuilder addAugmentation(Class<? extends Augmentation<Nodes>> augmentationType, Augmentation<Nodes> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NodesBuilder removeAugmentation(Class<? extends Augmentation<Nodes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Nodes build() {
        return new NodesImpl(this);
    }

    private static final class NodesImpl
    implements Nodes {
        private final List<Node> _node;
        private Map<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Nodes> getImplementedInterface() {
            return Nodes.class;
        }

        private NodesImpl(NodesBuilder base) {
            this._node = base.getNode();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Node> getNode() {
            return this._node;
        }

        public <E extends Augmentation<Nodes>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._node);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Nodes.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Nodes other = (Nodes)obj;
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NodesImpl otherImpl = (NodesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Nodes [";
            StringBuilder builder = new StringBuilder(name);
            if (this._node != null) {
                builder.append("_node=");
                builder.append(this._node);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

