/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.sdniwrapper.rev151007;

import java.util.Objects;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.spi.AbstractModule;
import org.opendaylight.controller.config.yang.md.sal.binding.BindingAwareBrokerServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.binding.NotificationProviderServiceServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.binding.RpcProviderRegistryServiceInterface;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.sdniwrapper.rev151007.SdniwrapperModuleMXBean;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(namespace="urn:opendaylight:params:xml:ns:yang:sdninterfaceapp:sdniwrapper", name="sdniwrapper", revision="2015-10-07")
public abstract class AbstractSdniwrapperModule
extends AbstractModule<AbstractSdniwrapperModule>
implements SdniwrapperModuleMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSdniwrapperModule.class);
    public static final JmxAttribute rpcRegistryJmxAttribute = new JmxAttribute("RpcRegistry");
    private ObjectName rpcRegistry;
    public static final JmxAttribute brokerJmxAttribute = new JmxAttribute("Broker");
    private ObjectName broker;
    public static final JmxAttribute notificationServiceJmxAttribute = new JmxAttribute("NotificationService");
    private ObjectName notificationService;
    private RpcProviderRegistry rpcRegistryDependency;
    private BindingAwareBroker brokerDependency;
    private NotificationProviderService notificationServiceDependency;

    public AbstractSdniwrapperModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public AbstractSdniwrapperModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractSdniwrapperModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, (AbstractModule)oldModule, oldInstance);
    }

    public void validate() {
        this.dependencyResolver.validateDependency(RpcProviderRegistryServiceInterface.class, this.rpcRegistry, rpcRegistryJmxAttribute);
        if (this.broker != null) {
            this.dependencyResolver.validateDependency(BindingAwareBrokerServiceInterface.class, this.broker, brokerJmxAttribute);
        }
        this.dependencyResolver.validateDependency(NotificationProviderServiceServiceInterface.class, this.notificationService, notificationServiceJmxAttribute);
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final RpcProviderRegistry getRpcRegistryDependency() {
        return this.rpcRegistryDependency;
    }

    protected final BindingAwareBroker getBrokerDependency() {
        return this.brokerDependency;
    }

    protected final NotificationProviderService getNotificationServiceDependency() {
        return this.notificationServiceDependency;
    }

    protected final void resolveDependencies() {
        if (this.broker != null) {
            this.brokerDependency = (BindingAwareBroker)this.dependencyResolver.resolveInstance(BindingAwareBroker.class, this.broker, brokerJmxAttribute);
        }
        this.rpcRegistryDependency = (RpcProviderRegistry)this.dependencyResolver.resolveInstance(RpcProviderRegistry.class, this.rpcRegistry, rpcRegistryJmxAttribute);
        this.notificationServiceDependency = (NotificationProviderService)this.dependencyResolver.resolveInstance(NotificationProviderService.class, this.notificationService, notificationServiceJmxAttribute);
    }

    public boolean canReuseInstance(AbstractSdniwrapperModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractSdniwrapperModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (!Objects.deepEquals(this.rpcRegistry, other.rpcRegistry)) {
            return false;
        }
        if (this.rpcRegistry != null && !this.dependencyResolver.canReuseDependency(this.rpcRegistry, rpcRegistryJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.broker, other.broker)) {
            return false;
        }
        if (this.broker != null && !this.dependencyResolver.canReuseDependency(this.broker, brokerJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.notificationService, other.notificationService)) {
            return false;
        }
        return this.notificationService == null || this.dependencyResolver.canReuseDependency(this.notificationService, notificationServiceJmxAttribute);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractSdniwrapperModule that = (AbstractSdniwrapperModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public ObjectName getRpcRegistry() {
        return this.rpcRegistry;
    }

    @Override
    @RequireInterface(value=RpcProviderRegistryServiceInterface.class)
    public void setRpcRegistry(ObjectName rpcRegistry) {
        this.rpcRegistry = rpcRegistry;
    }

    @Override
    public ObjectName getBroker() {
        return this.broker;
    }

    @Override
    @RequireInterface(value=BindingAwareBrokerServiceInterface.class)
    public void setBroker(ObjectName broker) {
        this.broker = broker;
    }

    @Override
    public ObjectName getNotificationService() {
        return this.notificationService;
    }

    @Override
    @RequireInterface(value=NotificationProviderServiceServiceInterface.class)
    public void setNotificationService(ObjectName notificationService) {
        this.notificationService = notificationService;
    }

    public Logger getLogger() {
        return LOG;
    }
}

