/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.sdninterfaceapp.impl.sdniwrapper;

import java.io.PrintWriter;
import java.net.Socket;
import java.util.TimerTask;
import org.opendaylight.sdninterfaceapp.impl.sdniwrapper.SdniMsgSynchronizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDNiClientCommunicator
extends TimerTask {
    private static final Logger log = LoggerFactory.getLogger(SDNiClientCommunicator.class);
    private static final int ServerPort = 8115;
    private static SDNiClientCommunicator clientCommunicator;
    private static SdniMsgSynchronizer sdniMsgSync;

    SDNiClientCommunicator() {
        sdniMsgSync = SdniMsgSynchronizer.getInstance();
    }

    public static SDNiClientCommunicator getInstance() {
        if (clientCommunicator == null) {
            clientCommunicator = new SDNiClientCommunicator();
        }
        return clientCommunicator;
    }

    public static void sendMsg() {
        log.info("Starting sendMsg.........!");
        StringBuffer sdniMsg = new StringBuffer();
        sdniMsgSync.getSDNITopoMessage(sdniMsg);
        sdniMsgSync.getSDNIQoSMessage(sdniMsg);
        for (String peerIP : sdniMsgSync.getPeerControllers()) {
            try {
                Socket echoSocket = new Socket(peerIP, 8115);
                Throwable throwable = null;
                try {
                    PrintWriter out = new PrintWriter(echoSocket.getOutputStream(), true);
                    Throwable throwable2 = null;
                    try {
                        if (sdniMsg == null) continue;
                        out.println(sdniMsg.toString());
                        log.info("Sending Message to Server : {}", (Object)peerIP);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (echoSocket == null) continue;
                    if (throwable != null) {
                        try {
                            echoSocket.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    echoSocket.close();
                }
            }
            catch (Exception e) {
                log.error("Couldn't get I/O for the connection to : {}", (Throwable)e);
            }
        }
    }

    @Override
    public void run() {
        SDNiClientCommunicator.sendMsg();
    }
}

