/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.sdninterfaceapp.impl;

import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareProvider;
import org.opendaylight.sdninterfaceapp.impl.SdniTopologyMsgServiceImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.msg.rev151006.OpendaylightSdniTopologyMsgService;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdniTopologyProvider
implements BindingAwareProvider,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SdniTopologyProvider.class);
    private DataBroker dataBroker = null;
    private BindingAwareBroker.RpcRegistration<OpendaylightSdniTopologyMsgService> sdniTopologyServiceRpc;

    public void onSessionInitiated(BindingAwareBroker.ProviderContext session) {
        LOG.info("SdniTopology Plugin Started");
        SdniTopologyMsgServiceImpl sdniTopologyMsgServiceImpl = SdniTopologyMsgServiceImpl.getInstance();
        this.sdniTopologyServiceRpc = session.addRpcImplementation(OpendaylightSdniTopologyMsgService.class, (RpcService)sdniTopologyMsgServiceImpl);
        this.dataBroker = (DataBroker)session.getSALService(DataBroker.class);
        sdniTopologyMsgServiceImpl.setBroker(this.dataBroker);
    }

    @Override
    public void close() throws Exception {
        LOG.info("SdniTopologyProvider Closed");
        if (this.sdniTopologyServiceRpc != null) {
            this.sdniTopologyServiceRpc.close();
        }
    }
}

