/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.sdninterfaceapp.impl;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.CheckedFuture;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.sdninterfaceapp.impl.database.SdniDataBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.msg.rev151006.GetAllPeerTopologyOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.msg.rev151006.GetAllPeerTopologyOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.msg.rev151006.GetTopologyOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.msg.rev151006.GetTopologyOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.msg.rev151006.OpendaylightSdniTopologyMsgService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.msg.rev151006.getallpeertopology.output.Controllers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.msg.rev151006.getallpeertopology.output.ControllersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.params.rev151006.sdn.topology.NetworkTopologyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.params.rev151006.sdn.topology.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.params.rev151006.sdn.topology.network.topology.TopologyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.params.rev151006.sdn.topology.network.topology.topology.Link;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.params.rev151006.sdn.topology.network.topology.topology.LinkBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.params.rev151006.sdn.topology.network.topology.topology.LinkKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.params.rev151006.sdn.topology.network.topology.topology.NodeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.params.rev151006.sdn.topology.network.topology.topology.NodeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.params.rev151006.sdn.topology.network.topology.topology.UnderlayTopologyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.params.rev151006.sdn.topology.network.topology.topology.UnderlayTopologyKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.params.rev151006.sdn.topology.network.topology.topology.node.TerminationPoint;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.params.rev151006.sdn.topology.network.topology.topology.node.TerminationPointBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.params.rev151006.sdn.topology.network.topology.topology.node.TerminationPointKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.LinkId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TpId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.DestinationBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.SourceBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.UnderlayTopology;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdniTopologyMsgServiceImpl
implements OpendaylightSdniTopologyMsgService {
    private static final int CPUS = Runtime.getRuntime().availableProcessors();
    private static final Logger log = LoggerFactory.getLogger(SdniTopologyMsgServiceImpl.class);
    private DataBroker dataService = null;
    private static SdniTopologyMsgServiceImpl sdniTopologyMsgServiceImpl = new SdniTopologyMsgServiceImpl();
    OpendaylightSdniTopologyMsgService SdniTopologyMsgService = null;
    NetworkTopologyBuilder networkTopologyBuilder = new NetworkTopologyBuilder();
    RpcResultBuilder rpcResultBuilder = null;
    GetTopologyOutputBuilder getTopologyOutputBuilder = new GetTopologyOutputBuilder();

    private String findIpAddress() {
        Enumeration<NetworkInterface> e = null;
        try {
            e = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e1) {
            log.error("Failed to get list of interfaces", (Throwable)e1);
            return null;
        }
        while (e.hasMoreElements()) {
            NetworkInterface n = e.nextElement();
            Enumeration<InetAddress> ee = n.getInetAddresses();
            while (ee.hasMoreElements()) {
                InetAddress i = ee.nextElement();
                log.debug("Trying address {}", (Object)i);
                if (!(i instanceof Inet4Address) || i.isLoopbackAddress()) continue;
                String hostAddress = i.getHostAddress();
                log.debug("Settled on controller address {}", (Object)hostAddress);
                return hostAddress;
            }
        }
        log.error("Failed to find a suitable controller address");
        return null;
    }

    private SdniTopologyMsgServiceImpl() {
    }

    public static SdniTopologyMsgServiceImpl getInstance() {
        return sdniTopologyMsgServiceImpl;
    }

    public Future<RpcResult<GetTopologyOutput>> getTopology() {
        log.debug("SdniTopology Plugin Started");
        List<org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology> topoList = this.getAllTopologies();
        ArrayList<Topology> myTopoList = new ArrayList<Topology>();
        if (topoList == null) {
            return null;
        }
        for (org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology topo : topoList) {
            TopologyBuilder myTopo = new TopologyBuilder();
            TopologyKey tkey = topo.getKey();
            myTopo.setKey(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.params.rev151006.sdn.topology.network.topology.TopologyKey(topo.getTopologyId()));
            myTopo.setLink(this.getLinks(topo.getLink()));
            myTopo.setNode(this.getNodes(topo.getNode()));
            myTopo.setTopologyId(topo.getTopologyId());
            myTopo.setServerProvided(topo.isServerProvided());
            myTopo.setUnderlayTopology(this.getUnderlayTopos(topo.getUnderlayTopology()));
            myTopoList.add(myTopo.build());
        }
        this.networkTopologyBuilder.setTopology(myTopoList);
        this.networkTopologyBuilder.setControllerIp(this.findIpAddress());
        this.getTopologyOutputBuilder.setNetworkTopology(this.networkTopologyBuilder.build());
        log.info("------------getTopologyOutputBuilder----------------");
        this.rpcResultBuilder = RpcResultBuilder.success((Object)this.getTopologyOutputBuilder.build());
        log.info("------------rpcResultBuilder----------------");
        return this.rpcResultBuilder.buildFuture();
    }

    private List<Link> getLinks(List<org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link> mdsalLinkList) {
        if (mdsalLinkList == null || mdsalLinkList.isEmpty()) {
            return null;
        }
        ArrayList<Link> result = new ArrayList<Link>();
        for (org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link l : mdsalLinkList) {
            LinkBuilder myLink = new LinkBuilder();
            myLink.setDestination(l.getDestination());
            myLink.setLinkId(l.getLinkId());
            myLink.setKey(new LinkKey(l.getLinkId()));
            myLink.setSource(l.getSource());
            myLink.setSupportingLink(l.getSupportingLink());
            result.add(myLink.build());
        }
        return result;
    }

    private List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.params.rev151006.sdn.topology.network.topology.topology.UnderlayTopology> getUnderlayTopos(List<UnderlayTopology> mdsalUnderlayTopoList) {
        if (mdsalUnderlayTopoList == null || mdsalUnderlayTopoList.isEmpty()) {
            return null;
        }
        ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.params.rev151006.sdn.topology.network.topology.topology.UnderlayTopology> result = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.params.rev151006.sdn.topology.network.topology.topology.UnderlayTopology>();
        for (UnderlayTopology utp : mdsalUnderlayTopoList) {
            UnderlayTopologyBuilder myUnderlayTopo = new UnderlayTopologyBuilder();
            myUnderlayTopo.setKey(new UnderlayTopologyKey(utp.getTopologyRef()));
            myUnderlayTopo.setTopologyRef(utp.getTopologyRef());
            result.add(myUnderlayTopo.build());
        }
        return result;
    }

    private List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.params.rev151006.sdn.topology.network.topology.topology.Node> getNodes(List<Node> mdsalNodeList) {
        if (mdsalNodeList == null || mdsalNodeList.isEmpty()) {
            return null;
        }
        ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.params.rev151006.sdn.topology.network.topology.topology.Node> result = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.params.rev151006.sdn.topology.network.topology.topology.Node>();
        for (Node n : mdsalNodeList) {
            NodeBuilder myNode = new NodeBuilder();
            myNode.setKey(new NodeKey(n.getNodeId()));
            myNode.setNodeId(n.getNodeId());
            myNode.setSupportingNode(n.getSupportingNode());
            ArrayList<TerminationPoint> myTpList = new ArrayList<TerminationPoint>();
            for (org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.node.TerminationPoint mdsalNodeTp : n.getTerminationPoint()) {
                TerminationPointBuilder myNodeTp = new TerminationPointBuilder();
                myNodeTp.setKey(new TerminationPointKey(mdsalNodeTp.getTpId()));
                myNodeTp.setTpId(mdsalNodeTp.getTpId());
                myNodeTp.setTpRef(mdsalNodeTp.getTpRef());
                myTpList.add(myNodeTp.build());
            }
            myNode.setTerminationPoint(myTpList);
            result.add(myNode.build());
        }
        return result;
    }

    private List<org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology> getAllTopologies() {
        Optional oNT;
        CheckedFuture lfONT;
        List<Object> topo = new ArrayList<org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology>();
        InstanceIdentifier ntII = InstanceIdentifier.builder(NetworkTopology.class).build();
        try (ReadOnlyTransaction rot = this.dataService.newReadOnlyTransaction();){
            lfONT = rot.read(LogicalDatastoreType.OPERATIONAL, ntII);
            rot.close();
        }
        try {
            oNT = (Optional)lfONT.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            log.warn(ex.getLocalizedMessage());
            return null;
        }
        if (oNT != null && oNT.isPresent()) {
            NetworkTopology networkTopo = (NetworkTopology)oNT.get();
            topo = networkTopo.getTopology();
        }
        return topo;
    }

    public void setBroker(DataBroker dataBroker) {
        this.dataService = dataBroker;
    }

    public Future<RpcResult<GetAllPeerTopologyOutput>> getAllPeerTopology() {
        log.info("In getAllPeerTopology START");
        GetAllPeerTopologyOutputBuilder outputBuilder = new GetAllPeerTopologyOutputBuilder();
        ArrayList<Controllers> controllers = new ArrayList<Controllers>();
        try {
            Set<String> controllersList;
            SdniDataBase sdb = SdniDataBase.getInstance();
            Map<String, List<String>> topologyData = sdb.getAllPeerTopology();
            log.info("after getAllPeerTopology of sdnjava" + topologyData);
            if (topologyData != null && !topologyData.isEmpty() && (controllersList = topologyData.keySet()) != null && !controllersList.isEmpty()) {
                log.info("In getAllPeerTopology controllersList : {}", (Object)controllersList.size());
                for (String controllerIp : controllersList) {
                    ControllersBuilder crtlBuilder = new ControllersBuilder();
                    ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.msg.rev151006.getallpeertopology.output.controllers.Link> linkList = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.msg.rev151006.getallpeertopology.output.controllers.Link>();
                    List<String> linkData = topologyData.get(controllerIp);
                    if (linkData != null && !linkData.isEmpty()) {
                        log.info("In getAllPeerTopology linkData : {}", (Object)linkData.size());
                        for (String link : linkData) {
                            String NODE2_ID;
                            String TP2_ID;
                            String NODE1_ID;
                            String TP1_ID;
                            String[] parts = link.split("->");
                            String source = parts[0];
                            String destination = parts[1];
                            String sw = "openflow";
                            if (source.contains(sw)) {
                                TP1_ID = source;
                                String[] sNodePort = source.split(":");
                                NODE1_ID = sNodePort[0] + ":" + sNodePort[1];
                            } else {
                                NODE1_ID = source;
                                TP1_ID = source;
                            }
                            if (destination.contains(sw)) {
                                TP2_ID = destination;
                                String[] dNodePort = destination.split(":");
                                NODE2_ID = dNodePort[0] + ":" + dNodePort[1];
                            } else {
                                TP2_ID = destination;
                                NODE2_ID = destination;
                            }
                            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.msg.rev151006.getallpeertopology.output.controllers.LinkBuilder linkBuilder = new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.topology.msg.rev151006.getallpeertopology.output.controllers.LinkBuilder();
                            DestinationBuilder destBuilder = new DestinationBuilder();
                            NodeId d_nid_l = new NodeId(NODE2_ID);
                            TpId d_tpid_l = new TpId(TP2_ID);
                            destBuilder.setDestNode(d_nid_l);
                            destBuilder.setDestTp(d_tpid_l);
                            linkBuilder.setDestination(destBuilder.build());
                            SourceBuilder souBuilder = new SourceBuilder();
                            NodeId s_nid_l = new NodeId(NODE1_ID);
                            TpId s_tpid_l = new TpId(TP1_ID);
                            souBuilder.setSourceNode(s_nid_l);
                            souBuilder.setSourceTp(s_tpid_l);
                            linkBuilder.setSource(souBuilder.build());
                            String Linkid = source.contains(sw) && destination.contains(sw) ? source : source + "/" + destination;
                            LinkId lid_l = new LinkId(Linkid);
                            linkBuilder.setLinkId(lid_l);
                            linkList.add(linkBuilder.build());
                        }
                    }
                    crtlBuilder.setControllerIp(controllerIp);
                    crtlBuilder.setLink(linkList);
                    controllers.add(crtlBuilder.build());
                }
            }
        }
        catch (Exception e) {
            log.error("Exception in getAllPeerTopology : {}", (Object)e.getMessage());
        }
        outputBuilder.setControllers(controllers);
        return RpcResultBuilder.success((Object)outputBuilder.build()).buildFuture();
    }
}

