package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.eth.src.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxmOfEthSrcBuilder} instances.
 *
 * @see NxmOfEthSrcBuilder
 *
 */
public class NxmOfEthSrcBuilder implements Builder<NxmOfEthSrc> {

    private MacAddress _macAddress;


    Map<Class<? extends Augmentation<NxmOfEthSrc>>, Augmentation<NxmOfEthSrc>> augmentation = Collections.emptyMap();

    public NxmOfEthSrcBuilder() {
    }
    public NxmOfEthSrcBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.MacAddressGrouping arg) {
        this._macAddress = arg.getMacAddress();
    }

    public NxmOfEthSrcBuilder(NxmOfEthSrc base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxmOfEthSrc>>, Augmentation<NxmOfEthSrc>> aug =((AugmentationHolder<NxmOfEthSrc>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._macAddress = base.getMacAddress();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.MacAddressGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.MacAddressGrouping) {
            this._macAddress = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.MacAddressGrouping)arg).getMacAddress();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.MacAddressGrouping]");
    }

    public MacAddress getMacAddress() {
        return _macAddress;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxmOfEthSrc>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxmOfEthSrcBuilder setMacAddress(final MacAddress value) {
        this._macAddress = value;
        return this;
    }
    
    public NxmOfEthSrcBuilder addAugmentation(Class<? extends Augmentation<NxmOfEthSrc>> augmentationType, Augmentation<NxmOfEthSrc> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxmOfEthSrcBuilder removeAugmentation(Class<? extends Augmentation<NxmOfEthSrc>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxmOfEthSrc build() {
        return new NxmOfEthSrcImpl(this);
    }

    private static final class NxmOfEthSrcImpl
        extends AbstractAugmentable<NxmOfEthSrc>
        implements NxmOfEthSrc {
    
        private final MacAddress _macAddress;
    
        NxmOfEthSrcImpl(NxmOfEthSrcBuilder base) {
            super(base.augmentation);
            this._macAddress = base.getMacAddress();
        }
    
        @Override
        public MacAddress getMacAddress() {
            return _macAddress;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_macAddress);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmOfEthSrc.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            NxmOfEthSrc other = (NxmOfEthSrc)obj;
            if (!Objects.equals(_macAddress, other.getMacAddress())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxmOfEthSrcImpl otherImpl = (NxmOfEthSrcImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxmOfEthSrc>>, Augmentation<NxmOfEthSrc>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxmOfEthSrc");
            CodeHelpers.appendValue(helper, "_macAddress", _macAddress);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
