package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.arp.tha.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxmNxArpThaBuilder} instances.
 *
 * @see NxmNxArpThaBuilder
 *
 */
public class NxmNxArpThaBuilder implements Builder<NxmNxArpTha> {

    private MacAddress _macAddress;


    Map<Class<? extends Augmentation<NxmNxArpTha>>, Augmentation<NxmNxArpTha>> augmentation = Collections.emptyMap();

    public NxmNxArpThaBuilder() {
    }
    public NxmNxArpThaBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.MacAddressGrouping arg) {
        this._macAddress = arg.getMacAddress();
    }

    public NxmNxArpThaBuilder(NxmNxArpTha base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxmNxArpTha>>, Augmentation<NxmNxArpTha>> aug =((AugmentationHolder<NxmNxArpTha>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._macAddress = base.getMacAddress();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.MacAddressGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.MacAddressGrouping) {
            this._macAddress = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.MacAddressGrouping)arg).getMacAddress();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.MacAddressGrouping]");
    }

    public MacAddress getMacAddress() {
        return _macAddress;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxmNxArpTha>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxmNxArpThaBuilder setMacAddress(final MacAddress value) {
        this._macAddress = value;
        return this;
    }
    
    public NxmNxArpThaBuilder addAugmentation(Class<? extends Augmentation<NxmNxArpTha>> augmentationType, Augmentation<NxmNxArpTha> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxmNxArpThaBuilder removeAugmentation(Class<? extends Augmentation<NxmNxArpTha>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxmNxArpTha build() {
        return new NxmNxArpThaImpl(this);
    }

    private static final class NxmNxArpThaImpl
        extends AbstractAugmentable<NxmNxArpTha>
        implements NxmNxArpTha {
    
        private final MacAddress _macAddress;
    
        NxmNxArpThaImpl(NxmNxArpThaBuilder base) {
            super(base.augmentation);
            this._macAddress = base.getMacAddress();
        }
    
        @Override
        public MacAddress getMacAddress() {
            return _macAddress;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_macAddress);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxArpTha.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            NxmNxArpTha other = (NxmNxArpTha)obj;
            if (!Objects.equals(_macAddress, other.getMacAddress())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxmNxArpThaImpl otherImpl = (NxmNxArpThaImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxmNxArpTha>>, Augmentation<NxmNxArpTha>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxmNxArpTha");
            CodeHelpers.appendValue(helper, "_macAddress", _macAddress);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
