package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Empty;

/**
 * Class that builds {@link SrcOfArpTpaCaseBuilder} instances.
 *
 * @see SrcOfArpTpaCaseBuilder
 *
 */
public class SrcOfArpTpaCaseBuilder implements Builder<SrcOfArpTpaCase> {

    private Empty _ofArpTpa;


    Map<Class<? extends Augmentation<SrcOfArpTpaCase>>, Augmentation<SrcOfArpTpaCase>> augmentation = Collections.emptyMap();

    public SrcOfArpTpaCaseBuilder() {
    }
    public SrcOfArpTpaCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfArpTpaGrouping arg) {
        this._ofArpTpa = arg.getOfArpTpa();
    }

    public SrcOfArpTpaCaseBuilder(SrcOfArpTpaCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcOfArpTpaCase>>, Augmentation<SrcOfArpTpaCase>> aug =((AugmentationHolder<SrcOfArpTpaCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._ofArpTpa = base.getOfArpTpa();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfArpTpaGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfArpTpaGrouping) {
            this._ofArpTpa = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfArpTpaGrouping)arg).getOfArpTpa();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfArpTpaGrouping]");
    }

    public Empty getOfArpTpa() {
        return _ofArpTpa;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SrcOfArpTpaCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcOfArpTpaCaseBuilder setOfArpTpa(final Empty value) {
        this._ofArpTpa = value;
        return this;
    }
    
    public SrcOfArpTpaCaseBuilder addAugmentation(Class<? extends Augmentation<SrcOfArpTpaCase>> augmentationType, Augmentation<SrcOfArpTpaCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcOfArpTpaCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcOfArpTpaCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcOfArpTpaCase build() {
        return new SrcOfArpTpaCaseImpl(this);
    }

    private static final class SrcOfArpTpaCaseImpl
        extends AbstractAugmentable<SrcOfArpTpaCase>
        implements SrcOfArpTpaCase {
    
        private final Empty _ofArpTpa;
    
        SrcOfArpTpaCaseImpl(SrcOfArpTpaCaseBuilder base) {
            super(base.augmentation);
            this._ofArpTpa = base.getOfArpTpa();
        }
    
        @Override
        public Empty getOfArpTpa() {
            return _ofArpTpa;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ofArpTpa);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcOfArpTpaCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            SrcOfArpTpaCase other = (SrcOfArpTpaCase)obj;
            if (!Objects.equals(_ofArpTpa, other.getOfArpTpa())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcOfArpTpaCaseImpl otherImpl = (SrcOfArpTpaCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcOfArpTpaCase>>, Augmentation<SrcOfArpTpaCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcOfArpTpaCase");
            CodeHelpers.appendValue(helper, "_ofArpTpa", _ofArpTpa);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
