package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Empty;

/**
 * Class that builds {@link SrcNxOfMplsLabelCaseBuilder} instances.
 *
 * @see SrcNxOfMplsLabelCaseBuilder
 *
 */
public class SrcNxOfMplsLabelCaseBuilder implements Builder<SrcNxOfMplsLabelCase> {

    private Empty _ofMplsLabel;


    Map<Class<? extends Augmentation<SrcNxOfMplsLabelCase>>, Augmentation<SrcNxOfMplsLabelCase>> augmentation = Collections.emptyMap();

    public SrcNxOfMplsLabelCaseBuilder() {
    }
    public SrcNxOfMplsLabelCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMplsLabelGrouping arg) {
        this._ofMplsLabel = arg.getOfMplsLabel();
    }

    public SrcNxOfMplsLabelCaseBuilder(SrcNxOfMplsLabelCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcNxOfMplsLabelCase>>, Augmentation<SrcNxOfMplsLabelCase>> aug =((AugmentationHolder<SrcNxOfMplsLabelCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._ofMplsLabel = base.getOfMplsLabel();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMplsLabelGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMplsLabelGrouping) {
            this._ofMplsLabel = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMplsLabelGrouping)arg).getOfMplsLabel();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMplsLabelGrouping]");
    }

    public Empty getOfMplsLabel() {
        return _ofMplsLabel;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SrcNxOfMplsLabelCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcNxOfMplsLabelCaseBuilder setOfMplsLabel(final Empty value) {
        this._ofMplsLabel = value;
        return this;
    }
    
    public SrcNxOfMplsLabelCaseBuilder addAugmentation(Class<? extends Augmentation<SrcNxOfMplsLabelCase>> augmentationType, Augmentation<SrcNxOfMplsLabelCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcNxOfMplsLabelCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxOfMplsLabelCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxOfMplsLabelCase build() {
        return new SrcNxOfMplsLabelCaseImpl(this);
    }

    private static final class SrcNxOfMplsLabelCaseImpl
        extends AbstractAugmentable<SrcNxOfMplsLabelCase>
        implements SrcNxOfMplsLabelCase {
    
        private final Empty _ofMplsLabel;
    
        SrcNxOfMplsLabelCaseImpl(SrcNxOfMplsLabelCaseBuilder base) {
            super(base.augmentation);
            this._ofMplsLabel = base.getOfMplsLabel();
        }
    
        @Override
        public Empty getOfMplsLabel() {
            return _ofMplsLabel;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ofMplsLabel);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcNxOfMplsLabelCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            SrcNxOfMplsLabelCase other = (SrcNxOfMplsLabelCase)obj;
            if (!Objects.equals(_ofMplsLabel, other.getOfMplsLabel())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcNxOfMplsLabelCaseImpl otherImpl = (SrcNxOfMplsLabelCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcNxOfMplsLabelCase>>, Augmentation<SrcNxOfMplsLabelCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcNxOfMplsLabelCase");
            CodeHelpers.appendValue(helper, "_ofMplsLabel", _ofMplsLabel);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
