package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.group.desc.stats.updated.group.desc.stats.buckets.bucket.action.action;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.load.grouping.NxRegLoad;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionRegLoadNotifGroupDescStatsUpdatedCaseBuilder} instances.
 *
 * @see NxActionRegLoadNotifGroupDescStatsUpdatedCaseBuilder
 *
 */
public class NxActionRegLoadNotifGroupDescStatsUpdatedCaseBuilder implements Builder<NxActionRegLoadNotifGroupDescStatsUpdatedCase> {

    private NxRegLoad _nxRegLoad;


    Map<Class<? extends Augmentation<NxActionRegLoadNotifGroupDescStatsUpdatedCase>>, Augmentation<NxActionRegLoadNotifGroupDescStatsUpdatedCase>> augmentation = Collections.emptyMap();

    public NxActionRegLoadNotifGroupDescStatsUpdatedCaseBuilder() {
    }
    public NxActionRegLoadNotifGroupDescStatsUpdatedCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegLoadGrouping arg) {
        this._nxRegLoad = arg.getNxRegLoad();
    }

    public NxActionRegLoadNotifGroupDescStatsUpdatedCaseBuilder(NxActionRegLoadNotifGroupDescStatsUpdatedCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionRegLoadNotifGroupDescStatsUpdatedCase>>, Augmentation<NxActionRegLoadNotifGroupDescStatsUpdatedCase>> aug =((AugmentationHolder<NxActionRegLoadNotifGroupDescStatsUpdatedCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxRegLoad = base.getNxRegLoad();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegLoadGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegLoadGrouping) {
            this._nxRegLoad = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegLoadGrouping)arg).getNxRegLoad();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegLoadGrouping]");
    }

    public NxRegLoad getNxRegLoad() {
        return _nxRegLoad;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionRegLoadNotifGroupDescStatsUpdatedCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionRegLoadNotifGroupDescStatsUpdatedCaseBuilder setNxRegLoad(final NxRegLoad value) {
        this._nxRegLoad = value;
        return this;
    }
    
    public NxActionRegLoadNotifGroupDescStatsUpdatedCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionRegLoadNotifGroupDescStatsUpdatedCase>> augmentationType, Augmentation<NxActionRegLoadNotifGroupDescStatsUpdatedCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionRegLoadNotifGroupDescStatsUpdatedCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionRegLoadNotifGroupDescStatsUpdatedCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionRegLoadNotifGroupDescStatsUpdatedCase build() {
        return new NxActionRegLoadNotifGroupDescStatsUpdatedCaseImpl(this);
    }

    private static final class NxActionRegLoadNotifGroupDescStatsUpdatedCaseImpl
        extends AbstractAugmentable<NxActionRegLoadNotifGroupDescStatsUpdatedCase>
        implements NxActionRegLoadNotifGroupDescStatsUpdatedCase {
    
        private final NxRegLoad _nxRegLoad;
    
        NxActionRegLoadNotifGroupDescStatsUpdatedCaseImpl(NxActionRegLoadNotifGroupDescStatsUpdatedCaseBuilder base) {
            super(base.augmentation);
            this._nxRegLoad = base.getNxRegLoad();
        }
    
        @Override
        public NxRegLoad getNxRegLoad() {
            return _nxRegLoad;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxRegLoad);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionRegLoadNotifGroupDescStatsUpdatedCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            NxActionRegLoadNotifGroupDescStatsUpdatedCase other = (NxActionRegLoadNotifGroupDescStatsUpdatedCase)obj;
            if (!Objects.equals(_nxRegLoad, other.getNxRegLoad())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionRegLoadNotifGroupDescStatsUpdatedCaseImpl otherImpl = (NxActionRegLoadNotifGroupDescStatsUpdatedCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionRegLoadNotifGroupDescStatsUpdatedCase>>, Augmentation<NxActionRegLoadNotifGroupDescStatsUpdatedCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionRegLoadNotifGroupDescStatsUpdatedCase");
            CodeHelpers.appendValue(helper, "_nxRegLoad", _nxRegLoad);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
