package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flows.statistics.update.flow.and.statistics.map.list.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.decap.grouping.NxDecap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCaseBuilder} instances.
 *
 * @see NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCaseBuilder
 *
 */
public class NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCaseBuilder implements Builder<NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCase> {

    private NxDecap _nxDecap;


    Map<Class<? extends Augmentation<NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCase>> augmentation = Collections.emptyMap();

    public NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCaseBuilder() {
    }
    public NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecapGrouping arg) {
        this._nxDecap = arg.getNxDecap();
    }

    public NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCaseBuilder(NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCase>> aug =((AugmentationHolder<NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxDecap = base.getNxDecap();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecapGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecapGrouping) {
            this._nxDecap = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecapGrouping)arg).getNxDecap();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecapGrouping]");
    }

    public NxDecap getNxDecap() {
        return _nxDecap;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCaseBuilder setNxDecap(final NxDecap value) {
        this._nxDecap = value;
        return this;
    }
    
    public NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCase>> augmentationType, Augmentation<NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCase build() {
        return new NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCaseImpl(this);
    }

    private static final class NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCaseImpl
        extends AbstractAugmentable<NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCase>
        implements NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCase {
    
        private final NxDecap _nxDecap;
    
        NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCaseImpl(NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCaseBuilder base) {
            super(base.augmentation);
            this._nxDecap = base.getNxDecap();
        }
    
        @Override
        public NxDecap getNxDecap() {
            return _nxDecap;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxDecap);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCase other = (NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCase)obj;
            if (!Objects.equals(_nxDecap, other.getNxDecap())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCaseImpl otherImpl = (NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCase");
            CodeHelpers.appendValue(helper, "_nxDecap", _nxDecap);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
