package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Empty;

/**
 * Class that builds {@link DstNxIpv6SrcCaseBuilder} instances.
 *
 * @see DstNxIpv6SrcCaseBuilder
 *
 */
public class DstNxIpv6SrcCaseBuilder implements Builder<DstNxIpv6SrcCase> {

    private Empty _nxIpv6Src;


    Map<Class<? extends Augmentation<DstNxIpv6SrcCase>>, Augmentation<DstNxIpv6SrcCase>> augmentation = Collections.emptyMap();

    public DstNxIpv6SrcCaseBuilder() {
    }
    public DstNxIpv6SrcCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6SrcGrouping arg) {
        this._nxIpv6Src = arg.getNxIpv6Src();
    }

    public DstNxIpv6SrcCaseBuilder(DstNxIpv6SrcCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DstNxIpv6SrcCase>>, Augmentation<DstNxIpv6SrcCase>> aug =((AugmentationHolder<DstNxIpv6SrcCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxIpv6Src = base.getNxIpv6Src();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6SrcGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6SrcGrouping) {
            this._nxIpv6Src = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6SrcGrouping)arg).getNxIpv6Src();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6SrcGrouping]");
    }

    public Empty getNxIpv6Src() {
        return _nxIpv6Src;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DstNxIpv6SrcCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstNxIpv6SrcCaseBuilder setNxIpv6Src(final Empty value) {
        this._nxIpv6Src = value;
        return this;
    }
    
    public DstNxIpv6SrcCaseBuilder addAugmentation(Class<? extends Augmentation<DstNxIpv6SrcCase>> augmentationType, Augmentation<DstNxIpv6SrcCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstNxIpv6SrcCaseBuilder removeAugmentation(Class<? extends Augmentation<DstNxIpv6SrcCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstNxIpv6SrcCase build() {
        return new DstNxIpv6SrcCaseImpl(this);
    }

    private static final class DstNxIpv6SrcCaseImpl
        extends AbstractAugmentable<DstNxIpv6SrcCase>
        implements DstNxIpv6SrcCase {
    
        private final Empty _nxIpv6Src;
    
        DstNxIpv6SrcCaseImpl(DstNxIpv6SrcCaseBuilder base) {
            super(base.augmentation);
            this._nxIpv6Src = base.getNxIpv6Src();
        }
    
        @Override
        public Empty getNxIpv6Src() {
            return _nxIpv6Src;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxIpv6Src);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DstNxIpv6SrcCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            DstNxIpv6SrcCase other = (DstNxIpv6SrcCase)obj;
            if (!Objects.equals(_nxIpv6Src, other.getNxIpv6Src())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstNxIpv6SrcCaseImpl otherImpl = (DstNxIpv6SrcCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DstNxIpv6SrcCase>>, Augmentation<DstNxIpv6SrcCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DstNxIpv6SrcCase");
            CodeHelpers.appendValue(helper, "_nxIpv6Src", _nxIpv6Src);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
