package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.add.group.input.buckets.bucket.action.action;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionMultipathRpcAddGroupCaseBuilder} instances.
 *
 * @see NxActionMultipathRpcAddGroupCaseBuilder
 *
 */
public class NxActionMultipathRpcAddGroupCaseBuilder implements Builder<NxActionMultipathRpcAddGroupCase> {

    private NxMultipath _nxMultipath;


    Map<Class<? extends Augmentation<NxActionMultipathRpcAddGroupCase>>, Augmentation<NxActionMultipathRpcAddGroupCase>> augmentation = Collections.emptyMap();

    public NxActionMultipathRpcAddGroupCaseBuilder() {
    }
    public NxActionMultipathRpcAddGroupCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping arg) {
        this._nxMultipath = arg.getNxMultipath();
    }

    public NxActionMultipathRpcAddGroupCaseBuilder(NxActionMultipathRpcAddGroupCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionMultipathRpcAddGroupCase>>, Augmentation<NxActionMultipathRpcAddGroupCase>> aug =((AugmentationHolder<NxActionMultipathRpcAddGroupCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxMultipath = base.getNxMultipath();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping) {
            this._nxMultipath = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping)arg).getNxMultipath();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping]");
    }

    public NxMultipath getNxMultipath() {
        return _nxMultipath;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionMultipathRpcAddGroupCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionMultipathRpcAddGroupCaseBuilder setNxMultipath(final NxMultipath value) {
        this._nxMultipath = value;
        return this;
    }
    
    public NxActionMultipathRpcAddGroupCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionMultipathRpcAddGroupCase>> augmentationType, Augmentation<NxActionMultipathRpcAddGroupCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionMultipathRpcAddGroupCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionMultipathRpcAddGroupCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionMultipathRpcAddGroupCase build() {
        return new NxActionMultipathRpcAddGroupCaseImpl(this);
    }

    private static final class NxActionMultipathRpcAddGroupCaseImpl
        extends AbstractAugmentable<NxActionMultipathRpcAddGroupCase>
        implements NxActionMultipathRpcAddGroupCase {
    
        private final NxMultipath _nxMultipath;
    
        NxActionMultipathRpcAddGroupCaseImpl(NxActionMultipathRpcAddGroupCaseBuilder base) {
            super(base.augmentation);
            this._nxMultipath = base.getNxMultipath();
        }
    
        @Override
        public NxMultipath getNxMultipath() {
            return _nxMultipath;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxMultipath);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionMultipathRpcAddGroupCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            NxActionMultipathRpcAddGroupCase other = (NxActionMultipathRpcAddGroupCase)obj;
            if (!Objects.equals(_nxMultipath, other.getNxMultipath())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionMultipathRpcAddGroupCaseImpl otherImpl = (NxActionMultipathRpcAddGroupCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionMultipathRpcAddGroupCase>>, Augmentation<NxActionMultipathRpcAddGroupCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionMultipathRpcAddGroupCase");
            CodeHelpers.appendValue(helper, "_nxMultipath", _nxMultipath);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
