package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.add.flow.input.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping.NxLearn;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionLearnRpcAddFlowApplyActionsCaseBuilder} instances.
 *
 * @see NxActionLearnRpcAddFlowApplyActionsCaseBuilder
 *
 */
public class NxActionLearnRpcAddFlowApplyActionsCaseBuilder implements Builder<NxActionLearnRpcAddFlowApplyActionsCase> {

    private NxLearn _nxLearn;


    Map<Class<? extends Augmentation<NxActionLearnRpcAddFlowApplyActionsCase>>, Augmentation<NxActionLearnRpcAddFlowApplyActionsCase>> augmentation = Collections.emptyMap();

    public NxActionLearnRpcAddFlowApplyActionsCaseBuilder() {
    }
    public NxActionLearnRpcAddFlowApplyActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping arg) {
        this._nxLearn = arg.getNxLearn();
    }

    public NxActionLearnRpcAddFlowApplyActionsCaseBuilder(NxActionLearnRpcAddFlowApplyActionsCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionLearnRpcAddFlowApplyActionsCase>>, Augmentation<NxActionLearnRpcAddFlowApplyActionsCase>> aug =((AugmentationHolder<NxActionLearnRpcAddFlowApplyActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxLearn = base.getNxLearn();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping) {
            this._nxLearn = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping)arg).getNxLearn();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping]");
    }

    public NxLearn getNxLearn() {
        return _nxLearn;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionLearnRpcAddFlowApplyActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionLearnRpcAddFlowApplyActionsCaseBuilder setNxLearn(final NxLearn value) {
        this._nxLearn = value;
        return this;
    }
    
    public NxActionLearnRpcAddFlowApplyActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionLearnRpcAddFlowApplyActionsCase>> augmentationType, Augmentation<NxActionLearnRpcAddFlowApplyActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionLearnRpcAddFlowApplyActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionLearnRpcAddFlowApplyActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionLearnRpcAddFlowApplyActionsCase build() {
        return new NxActionLearnRpcAddFlowApplyActionsCaseImpl(this);
    }

    private static final class NxActionLearnRpcAddFlowApplyActionsCaseImpl
        extends AbstractAugmentable<NxActionLearnRpcAddFlowApplyActionsCase>
        implements NxActionLearnRpcAddFlowApplyActionsCase {
    
        private final NxLearn _nxLearn;
    
        NxActionLearnRpcAddFlowApplyActionsCaseImpl(NxActionLearnRpcAddFlowApplyActionsCaseBuilder base) {
            super(base.augmentation);
            this._nxLearn = base.getNxLearn();
        }
    
        @Override
        public NxLearn getNxLearn() {
            return _nxLearn;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxLearn);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionLearnRpcAddFlowApplyActionsCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            NxActionLearnRpcAddFlowApplyActionsCase other = (NxActionLearnRpcAddFlowApplyActionsCase)obj;
            if (!Objects.equals(_nxLearn, other.getNxLearn())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionLearnRpcAddFlowApplyActionsCaseImpl otherImpl = (NxActionLearnRpcAddFlowApplyActionsCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionLearnRpcAddFlowApplyActionsCase>>, Augmentation<NxActionLearnRpcAddFlowApplyActionsCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionLearnRpcAddFlowApplyActionsCase");
            CodeHelpers.appendValue(helper, "_nxLearn", _nxLearn);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
