package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.tp.src.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxmNxCtTpSrcBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxmNxCtTpSrcBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxmNxCtTpSrcBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxmNxCtTpSrcBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxmNxCtTpSrcBuilder
 * @see Builder
 *
 */
public class NxmNxCtTpSrcBuilder implements Builder<NxmNxCtTpSrc> {

    private Integer _ctTpSrc;
    private Integer _mask;


    Map<Class<? extends Augmentation<NxmNxCtTpSrc>>, Augmentation<NxmNxCtTpSrc>> augmentation = Collections.emptyMap();

    public NxmNxCtTpSrcBuilder() {
    }

    public NxmNxCtTpSrcBuilder(NxmNxCtTpSrc base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxmNxCtTpSrc>>, Augmentation<NxmNxCtTpSrc>> aug =((AugmentationHolder<NxmNxCtTpSrc>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._ctTpSrc = base.getCtTpSrc();
        this._mask = base.getMask();
    }


    public Integer getCtTpSrc() {
        return _ctTpSrc;
    }
    
    public Integer getMask() {
        return _mask;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxmNxCtTpSrc>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkCtTpSrcRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public NxmNxCtTpSrcBuilder setCtTpSrc(final Integer value) {
    if (value != null) {
        checkCtTpSrcRange(value);
        
    }
        this._ctTpSrc = value;
        return this;
    }
    private static void checkMaskRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public NxmNxCtTpSrcBuilder setMask(final Integer value) {
    if (value != null) {
        checkMaskRange(value);
        
    }
        this._mask = value;
        return this;
    }
    
    public NxmNxCtTpSrcBuilder addAugmentation(Class<? extends Augmentation<NxmNxCtTpSrc>> augmentationType, Augmentation<NxmNxCtTpSrc> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxmNxCtTpSrcBuilder removeAugmentation(Class<? extends Augmentation<NxmNxCtTpSrc>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxmNxCtTpSrc build() {
        return new NxmNxCtTpSrcImpl(this);
    }

    private static final class NxmNxCtTpSrcImpl
        extends AbstractAugmentable<NxmNxCtTpSrc>
        implements NxmNxCtTpSrc {
    
        private final Integer _ctTpSrc;
        private final Integer _mask;
    
        NxmNxCtTpSrcImpl(NxmNxCtTpSrcBuilder base) {
            super(base.augmentation);
            this._ctTpSrc = base.getCtTpSrc();
            this._mask = base.getMask();
        }
    
        @Override
        public Class<NxmNxCtTpSrc> getImplementedInterface() {
            return NxmNxCtTpSrc.class;
        }
    
        @Override
        public Integer getCtTpSrc() {
            return _ctTpSrc;
        }
        
        @Override
        public Integer getMask() {
            return _mask;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ctTpSrc);
            result = prime * result + Objects.hashCode(_mask);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxCtTpSrc.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmNxCtTpSrc other = (NxmNxCtTpSrc)obj;
            if (!Objects.equals(_ctTpSrc, other.getCtTpSrc())) {
                return false;
            }
            if (!Objects.equals(_mask, other.getMask())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxmNxCtTpSrcImpl otherImpl = (NxmNxCtTpSrcImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxmNxCtTpSrc>>, Augmentation<NxmNxCtTpSrc>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxmNxCtTpSrc");
            CodeHelpers.appendValue(helper, "_ctTpSrc", _ctTpSrc);
            CodeHelpers.appendValue(helper, "_mask", _mask);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
