package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SrcOfEthSrcCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SrcOfEthSrcCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new SrcOfEthSrcCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SrcOfEthSrcCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SrcOfEthSrcCaseBuilder
 * @see Builder
 *
 */
public class SrcOfEthSrcCaseBuilder implements Builder<SrcOfEthSrcCase> {

    private Boolean _ofEthSrc;


    Map<Class<? extends Augmentation<SrcOfEthSrcCase>>, Augmentation<SrcOfEthSrcCase>> augmentation = Collections.emptyMap();

    public SrcOfEthSrcCaseBuilder() {
    }
    public SrcOfEthSrcCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthSrcGrouping arg) {
        this._ofEthSrc = arg.isOfEthSrc();
    }

    public SrcOfEthSrcCaseBuilder(SrcOfEthSrcCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcOfEthSrcCase>>, Augmentation<SrcOfEthSrcCase>> aug =((AugmentationHolder<SrcOfEthSrcCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._ofEthSrc = base.isOfEthSrc();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthSrcGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthSrcGrouping) {
            this._ofEthSrc = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthSrcGrouping)arg).isOfEthSrc();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthSrcGrouping]");
    }

    public Boolean isOfEthSrc() {
        return _ofEthSrc;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SrcOfEthSrcCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcOfEthSrcCaseBuilder setOfEthSrc(final Boolean value) {
        this._ofEthSrc = value;
        return this;
    }
    
    public SrcOfEthSrcCaseBuilder addAugmentation(Class<? extends Augmentation<SrcOfEthSrcCase>> augmentationType, Augmentation<SrcOfEthSrcCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcOfEthSrcCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcOfEthSrcCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcOfEthSrcCase build() {
        return new SrcOfEthSrcCaseImpl(this);
    }

    private static final class SrcOfEthSrcCaseImpl
        extends AbstractAugmentable<SrcOfEthSrcCase>
        implements SrcOfEthSrcCase {
    
        private final Boolean _ofEthSrc;
    
        SrcOfEthSrcCaseImpl(SrcOfEthSrcCaseBuilder base) {
            super(base.augmentation);
            this._ofEthSrc = base.isOfEthSrc();
        }
    
        @Override
        public Class<SrcOfEthSrcCase> getImplementedInterface() {
            return SrcOfEthSrcCase.class;
        }
    
        @Override
        public Boolean isOfEthSrc() {
            return _ofEthSrc;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ofEthSrc);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcOfEthSrcCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrcOfEthSrcCase other = (SrcOfEthSrcCase)obj;
            if (!Objects.equals(_ofEthSrc, other.isOfEthSrc())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcOfEthSrcCaseImpl otherImpl = (SrcOfEthSrcCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcOfEthSrcCase>>, Augmentation<SrcOfEthSrcCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcOfEthSrcCase");
            CodeHelpers.appendValue(helper, "_ofEthSrc", _ofEthSrc);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
