package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping;
import java.lang.Integer;
import java.lang.Short;
import java.math.BigInteger;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping.nx.learn.FlowMods;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * container nx-learn {
 *   leaf idle-timeout {
 *     type uint16;
 *   }
 *   leaf hard-timeout {
 *     type uint16;
 *   }
 *   leaf priority {
 *     type uint16;
 *   }
 *   leaf cookie {
 *     type uint64;
 *   }
 *   leaf flags {
 *     type uint16;
 *   }
 *   leaf table-id {
 *     type uint8;
 *   }
 *   leaf fin-idle-timeout {
 *     type uint16;
 *   }
 *   leaf fin-hard-timeout {
 *     type uint16;
 *   }
 *   list flow-mods {
 *     uses flow-mod-spec;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-action/nx-action-learn-grouping/nx-learn</i>
 *
 * <p>To create instances of this class use {@link NxLearnBuilder}.
 * @see NxLearnBuilder
 *
 */
public interface NxLearn
    extends
    ChildOf<NxActionLearnGrouping>,
    Augmentable<NxLearn>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("nx-learn");

    /**
     * @return <code>java.lang.Integer</code> <code>idleTimeout</code>, or <code>null</code> if not present
     */
    @Nullable Integer getIdleTimeout();
    
    /**
     * @return <code>java.lang.Integer</code> <code>hardTimeout</code>, or <code>null</code> if not present
     */
    @Nullable Integer getHardTimeout();
    
    /**
     * @return <code>java.lang.Integer</code> <code>priority</code>, or <code>null</code> if not present
     */
    @Nullable Integer getPriority();
    
    /**
     * @return <code>java.math.BigInteger</code> <code>cookie</code>, or <code>null</code> if not present
     */
    @Nullable BigInteger getCookie();
    
    /**
     * @return <code>java.lang.Integer</code> <code>flags</code>, or <code>null</code> if not present
     */
    @Nullable Integer getFlags();
    
    /**
     * @return <code>java.lang.Short</code> <code>tableId</code>, or <code>null</code> if not present
     */
    @Nullable Short getTableId();
    
    /**
     * @return <code>java.lang.Integer</code> <code>finIdleTimeout</code>, or <code>null</code> if not present
     */
    @Nullable Integer getFinIdleTimeout();
    
    /**
     * @return <code>java.lang.Integer</code> <code>finHardTimeout</code>, or <code>null</code> if not present
     */
    @Nullable Integer getFinHardTimeout();
    
    /**
     * @return <code>java.util.List</code> <code>flowMods</code>, or <code>null</code> if not present
     */
    @Nullable List<FlowMods> getFlowMods();
    
    /**
     * @return <code>java.util.List</code> <code>flowMods</code>, or an empty list if it is not present
     */
    default @NonNull List<FlowMods> nonnullFlowMods() {
        return CodeHelpers.nonnull(getFlowMods());
    }

}

