package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.group.desc.stats.updated.group.desc.stats.buckets.bucket.action.action;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.NxOutputReg;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionOutputRegNotifGroupDescStatsUpdatedCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxActionOutputRegNotifGroupDescStatsUpdatedCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxActionOutputRegNotifGroupDescStatsUpdatedCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxActionOutputRegNotifGroupDescStatsUpdatedCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxActionOutputRegNotifGroupDescStatsUpdatedCaseBuilder
 * @see Builder
 *
 */
public class NxActionOutputRegNotifGroupDescStatsUpdatedCaseBuilder implements Builder<NxActionOutputRegNotifGroupDescStatsUpdatedCase> {

    private NxOutputReg _nxOutputReg;


    Map<Class<? extends Augmentation<NxActionOutputRegNotifGroupDescStatsUpdatedCase>>, Augmentation<NxActionOutputRegNotifGroupDescStatsUpdatedCase>> augmentation = Collections.emptyMap();

    public NxActionOutputRegNotifGroupDescStatsUpdatedCaseBuilder() {
    }
    public NxActionOutputRegNotifGroupDescStatsUpdatedCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping arg) {
        this._nxOutputReg = arg.getNxOutputReg();
    }

    public NxActionOutputRegNotifGroupDescStatsUpdatedCaseBuilder(NxActionOutputRegNotifGroupDescStatsUpdatedCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionOutputRegNotifGroupDescStatsUpdatedCase>>, Augmentation<NxActionOutputRegNotifGroupDescStatsUpdatedCase>> aug =((AugmentationHolder<NxActionOutputRegNotifGroupDescStatsUpdatedCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxOutputReg = base.getNxOutputReg();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping) {
            this._nxOutputReg = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping)arg).getNxOutputReg();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping]");
    }

    public NxOutputReg getNxOutputReg() {
        return _nxOutputReg;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionOutputRegNotifGroupDescStatsUpdatedCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionOutputRegNotifGroupDescStatsUpdatedCaseBuilder setNxOutputReg(final NxOutputReg value) {
        this._nxOutputReg = value;
        return this;
    }
    
    public NxActionOutputRegNotifGroupDescStatsUpdatedCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionOutputRegNotifGroupDescStatsUpdatedCase>> augmentationType, Augmentation<NxActionOutputRegNotifGroupDescStatsUpdatedCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionOutputRegNotifGroupDescStatsUpdatedCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionOutputRegNotifGroupDescStatsUpdatedCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionOutputRegNotifGroupDescStatsUpdatedCase build() {
        return new NxActionOutputRegNotifGroupDescStatsUpdatedCaseImpl(this);
    }

    private static final class NxActionOutputRegNotifGroupDescStatsUpdatedCaseImpl
        extends AbstractAugmentable<NxActionOutputRegNotifGroupDescStatsUpdatedCase>
        implements NxActionOutputRegNotifGroupDescStatsUpdatedCase {
    
        private final NxOutputReg _nxOutputReg;
    
        NxActionOutputRegNotifGroupDescStatsUpdatedCaseImpl(NxActionOutputRegNotifGroupDescStatsUpdatedCaseBuilder base) {
            super(base.augmentation);
            this._nxOutputReg = base.getNxOutputReg();
        }
    
        @Override
        public Class<NxActionOutputRegNotifGroupDescStatsUpdatedCase> getImplementedInterface() {
            return NxActionOutputRegNotifGroupDescStatsUpdatedCase.class;
        }
    
        @Override
        public NxOutputReg getNxOutputReg() {
            return _nxOutputReg;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxOutputReg);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionOutputRegNotifGroupDescStatsUpdatedCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionOutputRegNotifGroupDescStatsUpdatedCase other = (NxActionOutputRegNotifGroupDescStatsUpdatedCase)obj;
            if (!Objects.equals(_nxOutputReg, other.getNxOutputReg())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionOutputRegNotifGroupDescStatsUpdatedCaseImpl otherImpl = (NxActionOutputRegNotifGroupDescStatsUpdatedCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionOutputRegNotifGroupDescStatsUpdatedCase>>, Augmentation<NxActionOutputRegNotifGroupDescStatsUpdatedCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionOutputRegNotifGroupDescStatsUpdatedCase");
            CodeHelpers.appendValue(helper, "_nxOutputReg", _nxOutputReg);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
