package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.group.desc.stats.updated.group.desc.stats.buckets.bucket.action.action;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.ct.clear.grouping.NxCtClear;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionCtClearNotifGroupDescStatsUpdatedCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxActionCtClearNotifGroupDescStatsUpdatedCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxActionCtClearNotifGroupDescStatsUpdatedCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxActionCtClearNotifGroupDescStatsUpdatedCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxActionCtClearNotifGroupDescStatsUpdatedCaseBuilder
 * @see Builder
 *
 */
public class NxActionCtClearNotifGroupDescStatsUpdatedCaseBuilder implements Builder<NxActionCtClearNotifGroupDescStatsUpdatedCase> {

    private NxCtClear _nxCtClear;


    Map<Class<? extends Augmentation<NxActionCtClearNotifGroupDescStatsUpdatedCase>>, Augmentation<NxActionCtClearNotifGroupDescStatsUpdatedCase>> augmentation = Collections.emptyMap();

    public NxActionCtClearNotifGroupDescStatsUpdatedCaseBuilder() {
    }
    public NxActionCtClearNotifGroupDescStatsUpdatedCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionCtClearGrouping arg) {
        this._nxCtClear = arg.getNxCtClear();
    }

    public NxActionCtClearNotifGroupDescStatsUpdatedCaseBuilder(NxActionCtClearNotifGroupDescStatsUpdatedCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionCtClearNotifGroupDescStatsUpdatedCase>>, Augmentation<NxActionCtClearNotifGroupDescStatsUpdatedCase>> aug =((AugmentationHolder<NxActionCtClearNotifGroupDescStatsUpdatedCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxCtClear = base.getNxCtClear();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionCtClearGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionCtClearGrouping) {
            this._nxCtClear = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionCtClearGrouping)arg).getNxCtClear();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionCtClearGrouping]");
    }

    public NxCtClear getNxCtClear() {
        return _nxCtClear;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionCtClearNotifGroupDescStatsUpdatedCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionCtClearNotifGroupDescStatsUpdatedCaseBuilder setNxCtClear(final NxCtClear value) {
        this._nxCtClear = value;
        return this;
    }
    
    public NxActionCtClearNotifGroupDescStatsUpdatedCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionCtClearNotifGroupDescStatsUpdatedCase>> augmentationType, Augmentation<NxActionCtClearNotifGroupDescStatsUpdatedCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionCtClearNotifGroupDescStatsUpdatedCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionCtClearNotifGroupDescStatsUpdatedCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionCtClearNotifGroupDescStatsUpdatedCase build() {
        return new NxActionCtClearNotifGroupDescStatsUpdatedCaseImpl(this);
    }

    private static final class NxActionCtClearNotifGroupDescStatsUpdatedCaseImpl
        extends AbstractAugmentable<NxActionCtClearNotifGroupDescStatsUpdatedCase>
        implements NxActionCtClearNotifGroupDescStatsUpdatedCase {
    
        private final NxCtClear _nxCtClear;
    
        NxActionCtClearNotifGroupDescStatsUpdatedCaseImpl(NxActionCtClearNotifGroupDescStatsUpdatedCaseBuilder base) {
            super(base.augmentation);
            this._nxCtClear = base.getNxCtClear();
        }
    
        @Override
        public Class<NxActionCtClearNotifGroupDescStatsUpdatedCase> getImplementedInterface() {
            return NxActionCtClearNotifGroupDescStatsUpdatedCase.class;
        }
    
        @Override
        public NxCtClear getNxCtClear() {
            return _nxCtClear;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxCtClear);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionCtClearNotifGroupDescStatsUpdatedCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionCtClearNotifGroupDescStatsUpdatedCase other = (NxActionCtClearNotifGroupDescStatsUpdatedCase)obj;
            if (!Objects.equals(_nxCtClear, other.getNxCtClear())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionCtClearNotifGroupDescStatsUpdatedCaseImpl otherImpl = (NxActionCtClearNotifGroupDescStatsUpdatedCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionCtClearNotifGroupDescStatsUpdatedCase>>, Augmentation<NxActionCtClearNotifGroupDescStatsUpdatedCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionCtClearNotifGroupDescStatsUpdatedCase");
            CodeHelpers.appendValue(helper, "_nxCtClear", _nxCtClear);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
