package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec.flow.mod.add.match.from.field._case.FlowModAddMatchFromField;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link FlowModAddMatchFromFieldCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     FlowModAddMatchFromFieldCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new FlowModAddMatchFromFieldCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of FlowModAddMatchFromFieldCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see FlowModAddMatchFromFieldCaseBuilder
 * @see Builder
 *
 */
public class FlowModAddMatchFromFieldCaseBuilder implements Builder<FlowModAddMatchFromFieldCase> {

    private FlowModAddMatchFromField _flowModAddMatchFromField;


    Map<Class<? extends Augmentation<FlowModAddMatchFromFieldCase>>, Augmentation<FlowModAddMatchFromFieldCase>> augmentation = Collections.emptyMap();

    public FlowModAddMatchFromFieldCaseBuilder() {
    }

    public FlowModAddMatchFromFieldCaseBuilder(FlowModAddMatchFromFieldCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<FlowModAddMatchFromFieldCase>>, Augmentation<FlowModAddMatchFromFieldCase>> aug =((AugmentationHolder<FlowModAddMatchFromFieldCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._flowModAddMatchFromField = base.getFlowModAddMatchFromField();
    }


    public FlowModAddMatchFromField getFlowModAddMatchFromField() {
        return _flowModAddMatchFromField;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlowModAddMatchFromFieldCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public FlowModAddMatchFromFieldCaseBuilder setFlowModAddMatchFromField(final FlowModAddMatchFromField value) {
        this._flowModAddMatchFromField = value;
        return this;
    }
    
    public FlowModAddMatchFromFieldCaseBuilder addAugmentation(Class<? extends Augmentation<FlowModAddMatchFromFieldCase>> augmentationType, Augmentation<FlowModAddMatchFromFieldCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public FlowModAddMatchFromFieldCaseBuilder removeAugmentation(Class<? extends Augmentation<FlowModAddMatchFromFieldCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowModAddMatchFromFieldCase build() {
        return new FlowModAddMatchFromFieldCaseImpl(this);
    }

    private static final class FlowModAddMatchFromFieldCaseImpl
        extends AbstractAugmentable<FlowModAddMatchFromFieldCase>
        implements FlowModAddMatchFromFieldCase {
    
        private final FlowModAddMatchFromField _flowModAddMatchFromField;
    
        FlowModAddMatchFromFieldCaseImpl(FlowModAddMatchFromFieldCaseBuilder base) {
            super(base.augmentation);
            this._flowModAddMatchFromField = base.getFlowModAddMatchFromField();
        }
    
        @Override
        public Class<FlowModAddMatchFromFieldCase> getImplementedInterface() {
            return FlowModAddMatchFromFieldCase.class;
        }
    
        @Override
        public FlowModAddMatchFromField getFlowModAddMatchFromField() {
            return _flowModAddMatchFromField;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_flowModAddMatchFromField);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowModAddMatchFromFieldCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlowModAddMatchFromFieldCase other = (FlowModAddMatchFromFieldCase)obj;
            if (!Objects.equals(_flowModAddMatchFromField, other.getFlowModAddMatchFromField())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlowModAddMatchFromFieldCaseImpl otherImpl = (FlowModAddMatchFromFieldCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlowModAddMatchFromFieldCase>>, Augmentation<FlowModAddMatchFromFieldCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlowModAddMatchFromFieldCase");
            CodeHelpers.appendValue(helper, "_flowModAddMatchFromField", _flowModAddMatchFromField);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
