package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.icmp.type.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.Short;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxmOfIcmpTypeBuilder} instances.
 *
 * @see NxmOfIcmpTypeBuilder
 *
 */
public class NxmOfIcmpTypeBuilder implements Builder<NxmOfIcmpType> {

    private Short _value;


    Map<Class<? extends Augmentation<NxmOfIcmpType>>, Augmentation<NxmOfIcmpType>> augmentation = Collections.emptyMap();

    public NxmOfIcmpTypeBuilder() {
    }

    public NxmOfIcmpTypeBuilder(NxmOfIcmpType base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxmOfIcmpType>>, Augmentation<NxmOfIcmpType>> aug =((AugmentationHolder<NxmOfIcmpType>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._value = base.getValue();
    }


    public Short getValue() {
        return _value;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxmOfIcmpType>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkValueRange(final short value) {
        if (value >= (short)0 && value <= (short)255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", value);
    }
    
    public NxmOfIcmpTypeBuilder setValue(final Short value) {
    if (value != null) {
        checkValueRange(value);
        
    }
        this._value = value;
        return this;
    }
    
    public NxmOfIcmpTypeBuilder addAugmentation(Class<? extends Augmentation<NxmOfIcmpType>> augmentationType, Augmentation<NxmOfIcmpType> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxmOfIcmpTypeBuilder removeAugmentation(Class<? extends Augmentation<NxmOfIcmpType>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxmOfIcmpType build() {
        return new NxmOfIcmpTypeImpl(this);
    }

    private static final class NxmOfIcmpTypeImpl
        extends AbstractAugmentable<NxmOfIcmpType>
        implements NxmOfIcmpType {
    
        private final Short _value;
    
        NxmOfIcmpTypeImpl(NxmOfIcmpTypeBuilder base) {
            super(base.augmentation);
            this._value = base.getValue();
        }
    
        @Override
        public Class<NxmOfIcmpType> getImplementedInterface() {
            return NxmOfIcmpType.class;
        }
    
        @Override
        public Short getValue() {
            return _value;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_value);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmOfIcmpType.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmOfIcmpType other = (NxmOfIcmpType)obj;
            if (!Objects.equals(_value, other.getValue())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxmOfIcmpTypeImpl otherImpl = (NxmOfIcmpTypeImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxmOfIcmpType>>, Augmentation<NxmOfIcmpType>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxmOfIcmpType");
            CodeHelpers.appendValue(helper, "_value", _value);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
