package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.mark.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxmNxCtMarkBuilder} instances.
 *
 * @see NxmNxCtMarkBuilder
 *
 */
public class NxmNxCtMarkBuilder implements Builder<NxmNxCtMark> {

    private Long _ctMark;
    private Long _mask;


    Map<Class<? extends Augmentation<NxmNxCtMark>>, Augmentation<NxmNxCtMark>> augmentation = Collections.emptyMap();

    public NxmNxCtMarkBuilder() {
    }

    public NxmNxCtMarkBuilder(NxmNxCtMark base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxmNxCtMark>>, Augmentation<NxmNxCtMark>> aug =((AugmentationHolder<NxmNxCtMark>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._ctMark = base.getCtMark();
        this._mask = base.getMask();
    }


    public Long getCtMark() {
        return _ctMark;
    }
    
    public Long getMask() {
        return _mask;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxmNxCtMark>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkCtMarkRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public NxmNxCtMarkBuilder setCtMark(final Long value) {
    if (value != null) {
        checkCtMarkRange(value);
        
    }
        this._ctMark = value;
        return this;
    }
    private static void checkMaskRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public NxmNxCtMarkBuilder setMask(final Long value) {
    if (value != null) {
        checkMaskRange(value);
        
    }
        this._mask = value;
        return this;
    }
    
    public NxmNxCtMarkBuilder addAugmentation(Class<? extends Augmentation<NxmNxCtMark>> augmentationType, Augmentation<NxmNxCtMark> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxmNxCtMarkBuilder removeAugmentation(Class<? extends Augmentation<NxmNxCtMark>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxmNxCtMark build() {
        return new NxmNxCtMarkImpl(this);
    }

    private static final class NxmNxCtMarkImpl
        extends AbstractAugmentable<NxmNxCtMark>
        implements NxmNxCtMark {
    
        private final Long _ctMark;
        private final Long _mask;
    
        NxmNxCtMarkImpl(NxmNxCtMarkBuilder base) {
            super(base.augmentation);
            this._ctMark = base.getCtMark();
            this._mask = base.getMask();
        }
    
        @Override
        public Class<NxmNxCtMark> getImplementedInterface() {
            return NxmNxCtMark.class;
        }
    
        @Override
        public Long getCtMark() {
            return _ctMark;
        }
        
        @Override
        public Long getMask() {
            return _mask;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ctMark);
            result = prime * result + Objects.hashCode(_mask);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxCtMark.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmNxCtMark other = (NxmNxCtMark)obj;
            if (!Objects.equals(_ctMark, other.getCtMark())) {
                return false;
            }
            if (!Objects.equals(_mask, other.getMask())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxmNxCtMarkImpl otherImpl = (NxmNxCtMarkImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxmNxCtMark>>, Augmentation<NxmNxCtMark>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxmNxCtMark");
            CodeHelpers.appendValue(helper, "_ctMark", _ctMark);
            CodeHelpers.appendValue(helper, "_mask", _mask);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
