package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.update.flow.input.updated.flow.instructions.instruction.instruction.write.actions._case.write.actions.action.action;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCaseBuilder} instances.
 *
 * @see NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCaseBuilder
 *
 */
public class NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCaseBuilder implements Builder<NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCase> {

    private NxConntrack _nxConntrack;


    Map<Class<? extends Augmentation<NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCase>>, Augmentation<NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCase>> augmentation = Collections.emptyMap();

    public NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCaseBuilder() {
    }
    public NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping arg) {
        this._nxConntrack = arg.getNxConntrack();
    }

    public NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCaseBuilder(NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCase>>, Augmentation<NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCase>> aug =((AugmentationHolder<NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxConntrack = base.getNxConntrack();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping) {
            this._nxConntrack = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping)arg).getNxConntrack();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping]");
    }

    public NxConntrack getNxConntrack() {
        return _nxConntrack;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCaseBuilder setNxConntrack(final NxConntrack value) {
        this._nxConntrack = value;
        return this;
    }
    
    public NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCase>> augmentationType, Augmentation<NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCase build() {
        return new NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCaseImpl(this);
    }

    private static final class NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCaseImpl
        extends AbstractAugmentable<NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCase>
        implements NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCase {
    
        private final NxConntrack _nxConntrack;
    
        NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCaseImpl(NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCaseBuilder base) {
            super(base.augmentation);
            this._nxConntrack = base.getNxConntrack();
        }
    
        @Override
        public Class<NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCase> getImplementedInterface() {
            return NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCase.class;
        }
    
        @Override
        public NxConntrack getNxConntrack() {
            return _nxConntrack;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxConntrack);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCase other = (NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCase)obj;
            if (!Objects.equals(_nxConntrack, other.getNxConntrack())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCaseImpl otherImpl = (NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCase>>, Augmentation<NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionConntrackRpcUpdateFlowUpdatedWriteActionsCase");
            CodeHelpers.appendValue(helper, "_nxConntrack", _nxConntrack);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
