package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.update.flow.input.original.flow.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.NxOutputReg;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCaseBuilder} instances.
 *
 * @see NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCaseBuilder
 *
 */
public class NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCaseBuilder implements Builder<NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCase> {

    private NxOutputReg _nxOutputReg;


    Map<Class<? extends Augmentation<NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCase>>, Augmentation<NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCase>> augmentation = Collections.emptyMap();

    public NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCaseBuilder() {
    }
    public NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping arg) {
        this._nxOutputReg = arg.getNxOutputReg();
    }

    public NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCaseBuilder(NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCase>>, Augmentation<NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCase>> aug =((AugmentationHolder<NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxOutputReg = base.getNxOutputReg();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping) {
            this._nxOutputReg = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping)arg).getNxOutputReg();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping]");
    }

    public NxOutputReg getNxOutputReg() {
        return _nxOutputReg;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCaseBuilder setNxOutputReg(final NxOutputReg value) {
        this._nxOutputReg = value;
        return this;
    }
    
    public NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCase>> augmentationType, Augmentation<NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCase build() {
        return new NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCaseImpl(this);
    }

    private static final class NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCaseImpl
        extends AbstractAugmentable<NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCase>
        implements NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCase {
    
        private final NxOutputReg _nxOutputReg;
    
        NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCaseImpl(NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCaseBuilder base) {
            super(base.augmentation);
            this._nxOutputReg = base.getNxOutputReg();
        }
    
        @Override
        public Class<NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCase> getImplementedInterface() {
            return NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCase.class;
        }
    
        @Override
        public NxOutputReg getNxOutputReg() {
            return _nxOutputReg;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxOutputReg);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCase other = (NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCase)obj;
            if (!Objects.equals(_nxOutputReg, other.getNxOutputReg())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCaseImpl otherImpl = (NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCase>>, Augmentation<NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionOutputRegRpcUpdateFlowOriginalApplyActionsCase");
            CodeHelpers.appendValue(helper, "_nxOutputReg", _nxOutputReg);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
