package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SrcOfEthDstCaseBuilder} instances.
 *
 * @see SrcOfEthDstCaseBuilder
 *
 */
public class SrcOfEthDstCaseBuilder implements Builder<SrcOfEthDstCase> {

    private Boolean _ofEthDst;


    Map<Class<? extends Augmentation<SrcOfEthDstCase>>, Augmentation<SrcOfEthDstCase>> augmentation = Collections.emptyMap();

    public SrcOfEthDstCaseBuilder() {
    }
    public SrcOfEthDstCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthDstGrouping arg) {
        this._ofEthDst = arg.isOfEthDst();
    }

    public SrcOfEthDstCaseBuilder(SrcOfEthDstCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcOfEthDstCase>>, Augmentation<SrcOfEthDstCase>> aug =((AugmentationHolder<SrcOfEthDstCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._ofEthDst = base.isOfEthDst();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthDstGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthDstGrouping) {
            this._ofEthDst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthDstGrouping)arg).isOfEthDst();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthDstGrouping]");
    }

    public Boolean isOfEthDst() {
        return _ofEthDst;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SrcOfEthDstCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcOfEthDstCaseBuilder setOfEthDst(final Boolean value) {
        this._ofEthDst = value;
        return this;
    }
    
    public SrcOfEthDstCaseBuilder addAugmentation(Class<? extends Augmentation<SrcOfEthDstCase>> augmentationType, Augmentation<SrcOfEthDstCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcOfEthDstCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcOfEthDstCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcOfEthDstCase build() {
        return new SrcOfEthDstCaseImpl(this);
    }

    private static final class SrcOfEthDstCaseImpl
        extends AbstractAugmentable<SrcOfEthDstCase>
        implements SrcOfEthDstCase {
    
        private final Boolean _ofEthDst;
    
        SrcOfEthDstCaseImpl(SrcOfEthDstCaseBuilder base) {
            super(base.augmentation);
            this._ofEthDst = base.isOfEthDst();
        }
    
        @Override
        public Class<SrcOfEthDstCase> getImplementedInterface() {
            return SrcOfEthDstCase.class;
        }
    
        @Override
        public Boolean isOfEthDst() {
            return _ofEthDst;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ofEthDst);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcOfEthDstCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrcOfEthDstCase other = (SrcOfEthDstCase)obj;
            if (!Objects.equals(_ofEthDst, other.isOfEthDst())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcOfEthDstCaseImpl otherImpl = (SrcOfEthDstCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcOfEthDstCase>>, Augmentation<SrcOfEthDstCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcOfEthDstCase");
            CodeHelpers.appendValue(helper, "_ofEthDst", _ofEthDst);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
