package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DstNxOfInPortCaseBuilder} instances.
 *
 * @see DstNxOfInPortCaseBuilder
 *
 */
public class DstNxOfInPortCaseBuilder implements Builder<DstNxOfInPortCase> {

    private Boolean _ofInPort;


    Map<Class<? extends Augmentation<DstNxOfInPortCase>>, Augmentation<DstNxOfInPortCase>> augmentation = Collections.emptyMap();

    public DstNxOfInPortCaseBuilder() {
    }
    public DstNxOfInPortCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfInPortGrouping arg) {
        this._ofInPort = arg.isOfInPort();
    }

    public DstNxOfInPortCaseBuilder(DstNxOfInPortCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DstNxOfInPortCase>>, Augmentation<DstNxOfInPortCase>> aug =((AugmentationHolder<DstNxOfInPortCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._ofInPort = base.isOfInPort();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfInPortGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfInPortGrouping) {
            this._ofInPort = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfInPortGrouping)arg).isOfInPort();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfInPortGrouping]");
    }

    public Boolean isOfInPort() {
        return _ofInPort;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DstNxOfInPortCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstNxOfInPortCaseBuilder setOfInPort(final Boolean value) {
        this._ofInPort = value;
        return this;
    }
    
    public DstNxOfInPortCaseBuilder addAugmentation(Class<? extends Augmentation<DstNxOfInPortCase>> augmentationType, Augmentation<DstNxOfInPortCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstNxOfInPortCaseBuilder removeAugmentation(Class<? extends Augmentation<DstNxOfInPortCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstNxOfInPortCase build() {
        return new DstNxOfInPortCaseImpl(this);
    }

    private static final class DstNxOfInPortCaseImpl
        extends AbstractAugmentable<DstNxOfInPortCase>
        implements DstNxOfInPortCase {
    
        private final Boolean _ofInPort;
    
        DstNxOfInPortCaseImpl(DstNxOfInPortCaseBuilder base) {
            super(base.augmentation);
            this._ofInPort = base.isOfInPort();
        }
    
        @Override
        public Class<DstNxOfInPortCase> getImplementedInterface() {
            return DstNxOfInPortCase.class;
        }
    
        @Override
        public Boolean isOfInPort() {
            return _ofInPort;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ofInPort);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DstNxOfInPortCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DstNxOfInPortCase other = (DstNxOfInPortCase)obj;
            if (!Objects.equals(_ofInPort, other.isOfInPort())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstNxOfInPortCaseImpl otherImpl = (DstNxOfInPortCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DstNxOfInPortCase>>, Augmentation<DstNxOfInPortCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DstNxOfInPortCase");
            CodeHelpers.appendValue(helper, "_ofInPort", _ofInPort);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
