package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DstNxNshc2CaseBuilder} instances.
 *
 * @see DstNxNshc2CaseBuilder
 *
 */
public class DstNxNshc2CaseBuilder implements Builder<DstNxNshc2Case> {

    private Boolean _nxNshc2Dst;


    Map<Class<? extends Augmentation<DstNxNshc2Case>>, Augmentation<DstNxNshc2Case>> augmentation = Collections.emptyMap();

    public DstNxNshc2CaseBuilder() {
    }
    public DstNxNshc2CaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping arg) {
        this._nxNshc2Dst = arg.isNxNshc2Dst();
    }

    public DstNxNshc2CaseBuilder(DstNxNshc2Case base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DstNxNshc2Case>>, Augmentation<DstNxNshc2Case>> aug =((AugmentationHolder<DstNxNshc2Case>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxNshc2Dst = base.isNxNshc2Dst();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping) {
            this._nxNshc2Dst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping)arg).isNxNshc2Dst();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping]");
    }

    public Boolean isNxNshc2Dst() {
        return _nxNshc2Dst;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DstNxNshc2Case>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstNxNshc2CaseBuilder setNxNshc2Dst(final Boolean value) {
        this._nxNshc2Dst = value;
        return this;
    }
    
    public DstNxNshc2CaseBuilder addAugmentation(Class<? extends Augmentation<DstNxNshc2Case>> augmentationType, Augmentation<DstNxNshc2Case> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstNxNshc2CaseBuilder removeAugmentation(Class<? extends Augmentation<DstNxNshc2Case>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstNxNshc2Case build() {
        return new DstNxNshc2CaseImpl(this);
    }

    private static final class DstNxNshc2CaseImpl
        extends AbstractAugmentable<DstNxNshc2Case>
        implements DstNxNshc2Case {
    
        private final Boolean _nxNshc2Dst;
    
        DstNxNshc2CaseImpl(DstNxNshc2CaseBuilder base) {
            super(base.augmentation);
            this._nxNshc2Dst = base.isNxNshc2Dst();
        }
    
        @Override
        public Class<DstNxNshc2Case> getImplementedInterface() {
            return DstNxNshc2Case.class;
        }
    
        @Override
        public Boolean isNxNshc2Dst() {
            return _nxNshc2Dst;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxNshc2Dst);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DstNxNshc2Case.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DstNxNshc2Case other = (DstNxNshc2Case)obj;
            if (!Objects.equals(_nxNshc2Dst, other.isNxNshc2Dst())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstNxNshc2CaseImpl otherImpl = (DstNxNshc2CaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DstNxNshc2Case>>, Augmentation<DstNxNshc2Case>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DstNxNshc2Case");
            CodeHelpers.appendValue(helper, "_nxNshc2Dst", _nxNshc2Dst);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
