package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.add.flow.input.instructions.instruction.instruction.write.actions._case.write.actions.action.action;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping.NxResubmit;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionResubmitRpcAddFlowWriteActionsCaseBuilder} instances.
 *
 * @see NxActionResubmitRpcAddFlowWriteActionsCaseBuilder
 *
 */
public class NxActionResubmitRpcAddFlowWriteActionsCaseBuilder implements Builder<NxActionResubmitRpcAddFlowWriteActionsCase> {

    private NxResubmit _nxResubmit;


    Map<Class<? extends Augmentation<NxActionResubmitRpcAddFlowWriteActionsCase>>, Augmentation<NxActionResubmitRpcAddFlowWriteActionsCase>> augmentation = Collections.emptyMap();

    public NxActionResubmitRpcAddFlowWriteActionsCaseBuilder() {
    }
    public NxActionResubmitRpcAddFlowWriteActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping arg) {
        this._nxResubmit = arg.getNxResubmit();
    }

    public NxActionResubmitRpcAddFlowWriteActionsCaseBuilder(NxActionResubmitRpcAddFlowWriteActionsCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionResubmitRpcAddFlowWriteActionsCase>>, Augmentation<NxActionResubmitRpcAddFlowWriteActionsCase>> aug =((AugmentationHolder<NxActionResubmitRpcAddFlowWriteActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxResubmit = base.getNxResubmit();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping) {
            this._nxResubmit = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping)arg).getNxResubmit();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping]");
    }

    public NxResubmit getNxResubmit() {
        return _nxResubmit;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionResubmitRpcAddFlowWriteActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionResubmitRpcAddFlowWriteActionsCaseBuilder setNxResubmit(final NxResubmit value) {
        this._nxResubmit = value;
        return this;
    }
    
    public NxActionResubmitRpcAddFlowWriteActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionResubmitRpcAddFlowWriteActionsCase>> augmentationType, Augmentation<NxActionResubmitRpcAddFlowWriteActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionResubmitRpcAddFlowWriteActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionResubmitRpcAddFlowWriteActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionResubmitRpcAddFlowWriteActionsCase build() {
        return new NxActionResubmitRpcAddFlowWriteActionsCaseImpl(this);
    }

    private static final class NxActionResubmitRpcAddFlowWriteActionsCaseImpl
        extends AbstractAugmentable<NxActionResubmitRpcAddFlowWriteActionsCase>
        implements NxActionResubmitRpcAddFlowWriteActionsCase {
    
        private final NxResubmit _nxResubmit;
    
        NxActionResubmitRpcAddFlowWriteActionsCaseImpl(NxActionResubmitRpcAddFlowWriteActionsCaseBuilder base) {
            super(base.augmentation);
            this._nxResubmit = base.getNxResubmit();
        }
    
        @Override
        public Class<NxActionResubmitRpcAddFlowWriteActionsCase> getImplementedInterface() {
            return NxActionResubmitRpcAddFlowWriteActionsCase.class;
        }
    
        @Override
        public NxResubmit getNxResubmit() {
            return _nxResubmit;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxResubmit);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionResubmitRpcAddFlowWriteActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionResubmitRpcAddFlowWriteActionsCase other = (NxActionResubmitRpcAddFlowWriteActionsCase)obj;
            if (!Objects.equals(_nxResubmit, other.getNxResubmit())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionResubmitRpcAddFlowWriteActionsCaseImpl otherImpl = (NxActionResubmitRpcAddFlowWriteActionsCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionResubmitRpcAddFlowWriteActionsCase>>, Augmentation<NxActionResubmitRpcAddFlowWriteActionsCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionResubmitRpcAddFlowWriteActionsCase");
            CodeHelpers.appendValue(helper, "_nxResubmit", _nxResubmit);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
