/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.load.grouping;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.load.grouping.NxRegLoad;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.load.grouping.nx.reg.load.Dst;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxRegLoadBuilder
implements Builder<NxRegLoad> {
    private Dst _dst;
    private BigInteger _value;
    Map<Class<? extends Augmentation<NxRegLoad>>, Augmentation<NxRegLoad>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKVALUERANGE_RANGES;

    public NxRegLoadBuilder() {
    }

    public NxRegLoadBuilder(NxRegLoad base) {
        Map aug;
        this._dst = base.getDst();
        this._value = base.getValue();
        if (base instanceof NxRegLoadImpl) {
            NxRegLoadImpl impl = (NxRegLoadImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxRegLoad>>, Augmentation<NxRegLoad>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxRegLoad>>, Augmentation<NxRegLoad>>(aug);
        }
    }

    public Dst getDst() {
        return this._dst;
    }

    public BigInteger getValue() {
        return this._value;
    }

    public <E$$ extends Augmentation<NxRegLoad>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public NxRegLoadBuilder setDst(Dst value) {
        this._dst = value;
        return this;
    }

    private static void checkValueRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKVALUERANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        CodeHelpers.throwInvalidRange((Object[])CHECKVALUERANGE_RANGES, (Object)value);
    }

    public NxRegLoadBuilder setValue(BigInteger value) {
        if (value != null) {
            NxRegLoadBuilder.checkValueRange(value);
        }
        this._value = value;
        return this;
    }

    public NxRegLoadBuilder addAugmentation(Class<? extends Augmentation<NxRegLoad>> augmentationType, Augmentation<NxRegLoad> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxRegLoad>>, Augmentation<NxRegLoad>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NxRegLoadBuilder removeAugmentation(Class<? extends Augmentation<NxRegLoad>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxRegLoad build() {
        return new NxRegLoadImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKVALUERANGE_RANGES = a;
    }

    private static final class NxRegLoadImpl
    implements NxRegLoad {
        private final Dst _dst;
        private final BigInteger _value;
        private Map<Class<? extends Augmentation<NxRegLoad>>, Augmentation<NxRegLoad>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        NxRegLoadImpl(NxRegLoadBuilder base) {
            this._dst = base.getDst();
            this._value = base.getValue();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<NxRegLoad> getImplementedInterface() {
            return NxRegLoad.class;
        }

        @Override
        public Dst getDst() {
            return this._dst;
        }

        @Override
        public BigInteger getValue() {
            return this._value;
        }

        public <E$$ extends Augmentation<NxRegLoad>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._dst);
            result = 31 * result + Objects.hashCode(this._value);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxRegLoad.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxRegLoad other = (NxRegLoad)obj;
            if (!Objects.equals(this._dst, other.getDst())) {
                return false;
            }
            if (!Objects.equals(this._value, other.getValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxRegLoadImpl otherImpl = (NxRegLoadImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxRegLoad>>, Augmentation<NxRegLoad>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NxRegLoad");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_dst", (Object)this._dst);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (Object)this._value);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

