/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.decap.grouping;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.PacketTypeFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.decap.grouping.NxDecap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxDecapBuilder
implements Builder<NxDecap> {
    private Long _packetType;
    Map<Class<? extends Augmentation<NxDecap>>, Augmentation<NxDecap>> augmentation = Collections.emptyMap();

    public NxDecapBuilder() {
    }

    public NxDecapBuilder(PacketTypeFields arg) {
        this._packetType = arg.getPacketType();
    }

    public NxDecapBuilder(NxDecap base) {
        Map aug;
        this._packetType = base.getPacketType();
        if (base instanceof NxDecapImpl) {
            NxDecapImpl impl = (NxDecapImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxDecap>>, Augmentation<NxDecap>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxDecap>>, Augmentation<NxDecap>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PacketTypeFields) {
            this._packetType = ((PacketTypeFields)arg).getPacketType();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.PacketTypeFields]");
    }

    public Long getPacketType() {
        return this._packetType;
    }

    public <E$$ extends Augmentation<NxDecap>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkPacketTypeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public NxDecapBuilder setPacketType(Long value) {
        if (value != null) {
            NxDecapBuilder.checkPacketTypeRange(value);
        }
        this._packetType = value;
        return this;
    }

    public NxDecapBuilder addAugmentation(Class<? extends Augmentation<NxDecap>> augmentationType, Augmentation<NxDecap> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxDecap>>, Augmentation<NxDecap>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NxDecapBuilder removeAugmentation(Class<? extends Augmentation<NxDecap>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxDecap build() {
        return new NxDecapImpl(this);
    }

    private static final class NxDecapImpl
    implements NxDecap {
        private final Long _packetType;
        private Map<Class<? extends Augmentation<NxDecap>>, Augmentation<NxDecap>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        NxDecapImpl(NxDecapBuilder base) {
            this._packetType = base.getPacketType();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<NxDecap> getImplementedInterface() {
            return NxDecap.class;
        }

        public Long getPacketType() {
            return this._packetType;
        }

        public <E$$ extends Augmentation<NxDecap>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._packetType);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxDecap.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxDecap other = (NxDecap)obj;
            if (!Objects.equals(this._packetType, other.getPacketType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxDecapImpl otherImpl = (NxDecapImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxDecap>>, Augmentation<NxDecap>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NxDecap");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_packetType", (Object)this._packetType);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

