package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsh.np.grouping;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.Short;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxmNxNshNpBuilder} instances.
 *
 * @see NxmNxNshNpBuilder
 *
 */
public class NxmNxNshNpBuilder implements Builder<NxmNxNshNp> {

    private Short _value;


    Map<Class<? extends Augmentation<NxmNxNshNp>>, Augmentation<NxmNxNshNp>> augmentation = Collections.emptyMap();

    public NxmNxNshNpBuilder() {
    }

    public NxmNxNshNpBuilder(NxmNxNshNp base) {
        this._value = base.getValue();
        if (base instanceof NxmNxNshNpImpl) {
            NxmNxNshNpImpl impl = (NxmNxNshNpImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxmNxNshNp>>, Augmentation<NxmNxNshNp>> aug =((AugmentationHolder<NxmNxNshNp>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    public Short getValue() {
        return _value;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxmNxNshNp>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkValueRange(final short value) {
        if (value >= (short)0 && value <= (short)255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", value);
    }
    
    public NxmNxNshNpBuilder setValue(final Short value) {
    if (value != null) {
        checkValueRange(value);
        
    }
        this._value = value;
        return this;
    }
    
    public NxmNxNshNpBuilder addAugmentation(Class<? extends Augmentation<NxmNxNshNp>> augmentationType, Augmentation<NxmNxNshNp> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxmNxNshNpBuilder removeAugmentation(Class<? extends Augmentation<NxmNxNshNp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxmNxNshNp build() {
        return new NxmNxNshNpImpl(this);
    }

    private static final class NxmNxNshNpImpl implements NxmNxNshNp {
    
        private final Short _value;
    
        private Map<Class<? extends Augmentation<NxmNxNshNp>>, Augmentation<NxmNxNshNp>> augmentation = Collections.emptyMap();
    
        NxmNxNshNpImpl(NxmNxNshNpBuilder base) {
            this._value = base.getValue();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxmNxNshNp> getImplementedInterface() {
            return NxmNxNshNp.class;
        }
    
        @Override
        public Short getValue() {
            return _value;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<NxmNxNshNp>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_value);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxNshNp.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmNxNshNp other = (NxmNxNshNp)obj;
            if (!Objects.equals(_value, other.getValue())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxmNxNshNpImpl otherImpl = (NxmNxNshNpImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxmNxNshNp>>, Augmentation<NxmNxNshNp>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxmNxNshNp");
            CodeHelpers.appendValue(helper, "_value", _value);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
