package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.update.flow.input.updated.flow.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCaseBuilder} instances.
 *
 * @see NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCaseBuilder
 *
 */
public class NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCaseBuilder implements Builder<NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase> {

    private NxMultipath _nxMultipath;


    Map<Class<? extends Augmentation<NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase>>, Augmentation<NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase>> augmentation = Collections.emptyMap();

    public NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCaseBuilder() {
    }
    public NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping arg) {
        this._nxMultipath = arg.getNxMultipath();
    }

    public NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCaseBuilder(NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase base) {
        this._nxMultipath = base.getNxMultipath();
        if (base instanceof NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCaseImpl) {
            NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCaseImpl impl = (NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase>>, Augmentation<NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase>> aug =((AugmentationHolder<NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping) {
            this._nxMultipath = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping)arg).getNxMultipath();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping]");
    }

    public NxMultipath getNxMultipath() {
        return _nxMultipath;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCaseBuilder setNxMultipath(final NxMultipath value) {
        this._nxMultipath = value;
        return this;
    }
    
    public NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase>> augmentationType, Augmentation<NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase build() {
        return new NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCaseImpl(this);
    }

    private static final class NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCaseImpl implements NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase {
    
        private final NxMultipath _nxMultipath;
    
        private Map<Class<? extends Augmentation<NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase>>, Augmentation<NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase>> augmentation = Collections.emptyMap();
    
        NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCaseImpl(NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCaseBuilder base) {
            this._nxMultipath = base.getNxMultipath();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase> getImplementedInterface() {
            return NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase.class;
        }
    
        @Override
        public NxMultipath getNxMultipath() {
            return _nxMultipath;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxMultipath);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase other = (NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase)obj;
            if (!Objects.equals(_nxMultipath, other.getNxMultipath())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCaseImpl otherImpl = (NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase>>, Augmentation<NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionMultipathRpcUpdateFlowUpdatedApplyActionsCase");
            CodeHelpers.appendValue(helper, "_nxMultipath", _nxMultipath);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
