package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec.flow.mod.add.match.from.field._case;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link FlowModAddMatchFromFieldBuilder} instances.
 *
 * @see FlowModAddMatchFromFieldBuilder
 *
 */
public class FlowModAddMatchFromFieldBuilder implements Builder<FlowModAddMatchFromField> {

    private Long _dstField;
    private Integer _dstOfs;
    private Integer _flowModNumBits;
    private Long _srcField;
    private Integer _srcOfs;


    Map<Class<? extends Augmentation<FlowModAddMatchFromField>>, Augmentation<FlowModAddMatchFromField>> augmentation = Collections.emptyMap();

    public FlowModAddMatchFromFieldBuilder() {
    }

    public FlowModAddMatchFromFieldBuilder(FlowModAddMatchFromField base) {
        this._dstField = base.getDstField();
        this._dstOfs = base.getDstOfs();
        this._flowModNumBits = base.getFlowModNumBits();
        this._srcField = base.getSrcField();
        this._srcOfs = base.getSrcOfs();
        if (base instanceof FlowModAddMatchFromFieldImpl) {
            FlowModAddMatchFromFieldImpl impl = (FlowModAddMatchFromFieldImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<FlowModAddMatchFromField>>, Augmentation<FlowModAddMatchFromField>> aug =((AugmentationHolder<FlowModAddMatchFromField>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    public Long getDstField() {
        return _dstField;
    }
    
    public Integer getDstOfs() {
        return _dstOfs;
    }
    
    public Integer getFlowModNumBits() {
        return _flowModNumBits;
    }
    
    public Long getSrcField() {
        return _srcField;
    }
    
    public Integer getSrcOfs() {
        return _srcOfs;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlowModAddMatchFromField>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkDstFieldRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public FlowModAddMatchFromFieldBuilder setDstField(final Long value) {
    if (value != null) {
        checkDstFieldRange(value);
        
    }
        this._dstField = value;
        return this;
    }
    private static void checkDstOfsRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public FlowModAddMatchFromFieldBuilder setDstOfs(final Integer value) {
    if (value != null) {
        checkDstOfsRange(value);
        
    }
        this._dstOfs = value;
        return this;
    }
    private static void checkFlowModNumBitsRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public FlowModAddMatchFromFieldBuilder setFlowModNumBits(final Integer value) {
    if (value != null) {
        checkFlowModNumBitsRange(value);
        
    }
        this._flowModNumBits = value;
        return this;
    }
    private static void checkSrcFieldRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public FlowModAddMatchFromFieldBuilder setSrcField(final Long value) {
    if (value != null) {
        checkSrcFieldRange(value);
        
    }
        this._srcField = value;
        return this;
    }
    private static void checkSrcOfsRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public FlowModAddMatchFromFieldBuilder setSrcOfs(final Integer value) {
    if (value != null) {
        checkSrcOfsRange(value);
        
    }
        this._srcOfs = value;
        return this;
    }
    
    public FlowModAddMatchFromFieldBuilder addAugmentation(Class<? extends Augmentation<FlowModAddMatchFromField>> augmentationType, Augmentation<FlowModAddMatchFromField> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public FlowModAddMatchFromFieldBuilder removeAugmentation(Class<? extends Augmentation<FlowModAddMatchFromField>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowModAddMatchFromField build() {
        return new FlowModAddMatchFromFieldImpl(this);
    }

    private static final class FlowModAddMatchFromFieldImpl implements FlowModAddMatchFromField {
    
        private final Long _dstField;
        private final Integer _dstOfs;
        private final Integer _flowModNumBits;
        private final Long _srcField;
        private final Integer _srcOfs;
    
        private Map<Class<? extends Augmentation<FlowModAddMatchFromField>>, Augmentation<FlowModAddMatchFromField>> augmentation = Collections.emptyMap();
    
        FlowModAddMatchFromFieldImpl(FlowModAddMatchFromFieldBuilder base) {
            this._dstField = base.getDstField();
            this._dstOfs = base.getDstOfs();
            this._flowModNumBits = base.getFlowModNumBits();
            this._srcField = base.getSrcField();
            this._srcOfs = base.getSrcOfs();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<FlowModAddMatchFromField> getImplementedInterface() {
            return FlowModAddMatchFromField.class;
        }
    
        @Override
        public Long getDstField() {
            return _dstField;
        }
        
        @Override
        public Integer getDstOfs() {
            return _dstOfs;
        }
        
        @Override
        public Integer getFlowModNumBits() {
            return _flowModNumBits;
        }
        
        @Override
        public Long getSrcField() {
            return _srcField;
        }
        
        @Override
        public Integer getSrcOfs() {
            return _srcOfs;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<FlowModAddMatchFromField>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_dstField);
            result = prime * result + Objects.hashCode(_dstOfs);
            result = prime * result + Objects.hashCode(_flowModNumBits);
            result = prime * result + Objects.hashCode(_srcField);
            result = prime * result + Objects.hashCode(_srcOfs);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowModAddMatchFromField.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlowModAddMatchFromField other = (FlowModAddMatchFromField)obj;
            if (!Objects.equals(_dstField, other.getDstField())) {
                return false;
            }
            if (!Objects.equals(_dstOfs, other.getDstOfs())) {
                return false;
            }
            if (!Objects.equals(_flowModNumBits, other.getFlowModNumBits())) {
                return false;
            }
            if (!Objects.equals(_srcField, other.getSrcField())) {
                return false;
            }
            if (!Objects.equals(_srcOfs, other.getSrcOfs())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlowModAddMatchFromFieldImpl otherImpl = (FlowModAddMatchFromFieldImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlowModAddMatchFromField>>, Augmentation<FlowModAddMatchFromField>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlowModAddMatchFromField");
            CodeHelpers.appendValue(helper, "_dstField", _dstField);
            CodeHelpers.appendValue(helper, "_dstOfs", _dstOfs);
            CodeHelpers.appendValue(helper, "_flowModNumBits", _flowModNumBits);
            CodeHelpers.appendValue(helper, "_srcField", _srcField);
            CodeHelpers.appendValue(helper, "_srcOfs", _srcOfs);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
