/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.pkt.mark.grouping;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.pkt.mark.grouping.NxmNxPktMark;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxmNxPktMarkBuilder
implements Builder<NxmNxPktMark> {
    private Long _mask;
    private Long _pktMark;
    Map<Class<? extends Augmentation<NxmNxPktMark>>, Augmentation<NxmNxPktMark>> augmentation = Collections.emptyMap();

    public NxmNxPktMarkBuilder() {
    }

    public NxmNxPktMarkBuilder(NxmNxPktMark base) {
        Map aug;
        this._mask = base.getMask();
        this._pktMark = base.getPktMark();
        if (base instanceof NxmNxPktMarkImpl) {
            NxmNxPktMarkImpl impl = (NxmNxPktMarkImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxPktMark>>, Augmentation<NxmNxPktMark>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxPktMark>>, Augmentation<NxmNxPktMark>>(aug);
        }
    }

    public Long getMask() {
        return this._mask;
    }

    public Long getPktMark() {
        return this._pktMark;
    }

    public <E extends Augmentation<NxmNxPktMark>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkMaskRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public NxmNxPktMarkBuilder setMask(Long value) {
        if (value != null) {
            NxmNxPktMarkBuilder.checkMaskRange(value);
        }
        this._mask = value;
        return this;
    }

    private static void checkPktMarkRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public NxmNxPktMarkBuilder setPktMark(Long value) {
        if (value != null) {
            NxmNxPktMarkBuilder.checkPktMarkRange(value);
        }
        this._pktMark = value;
        return this;
    }

    public NxmNxPktMarkBuilder addAugmentation(Class<? extends Augmentation<NxmNxPktMark>> augmentationType, Augmentation<NxmNxPktMark> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxPktMark>>, Augmentation<NxmNxPktMark>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NxmNxPktMarkBuilder removeAugmentation(Class<? extends Augmentation<NxmNxPktMark>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxmNxPktMark build() {
        return new NxmNxPktMarkImpl(this);
    }

    private static final class NxmNxPktMarkImpl
    implements NxmNxPktMark {
        private final Long _mask;
        private final Long _pktMark;
        private Map<Class<? extends Augmentation<NxmNxPktMark>>, Augmentation<NxmNxPktMark>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        NxmNxPktMarkImpl(NxmNxPktMarkBuilder base) {
            this._mask = base.getMask();
            this._pktMark = base.getPktMark();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<NxmNxPktMark> getImplementedInterface() {
            return NxmNxPktMark.class;
        }

        @Override
        public Long getMask() {
            return this._mask;
        }

        @Override
        public Long getPktMark() {
            return this._pktMark;
        }

        public <E extends Augmentation<NxmNxPktMark>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._mask);
            result = 31 * result + Objects.hashCode(this._pktMark);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxPktMark.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmNxPktMark other = (NxmNxPktMark)obj;
            if (!Objects.equals(this._mask, other.getMask())) {
                return false;
            }
            if (!Objects.equals(this._pktMark, other.getPktMark())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxmNxPktMarkImpl otherImpl = (NxmNxPktMarkImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxmNxPktMark>>, Augmentation<NxmNxPktMark>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NxmNxPktMark");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_mask", (Object)this._mask);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_pktMark", (Object)this._pktMark);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

