package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SrcNxNshc1CaseBuilder} instances.
 *
 * @see SrcNxNshc1CaseBuilder
 *
 */
public class SrcNxNshc1CaseBuilder implements Builder<SrcNxNshc1Case> {

    private Boolean _nxNshc1Dst;


    Map<Class<? extends Augmentation<SrcNxNshc1Case>>, Augmentation<SrcNxNshc1Case>> augmentation = Collections.emptyMap();

    public SrcNxNshc1CaseBuilder() {
    }
    public SrcNxNshc1CaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc1Grouping arg) {
        this._nxNshc1Dst = arg.isNxNshc1Dst();
    }

    public SrcNxNshc1CaseBuilder(SrcNxNshc1Case base) {
        this._nxNshc1Dst = base.isNxNshc1Dst();
        if (base instanceof SrcNxNshc1CaseImpl) {
            SrcNxNshc1CaseImpl impl = (SrcNxNshc1CaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcNxNshc1Case>>, Augmentation<SrcNxNshc1Case>> aug =((AugmentationHolder<SrcNxNshc1Case>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc1Grouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc1Grouping) {
            this._nxNshc1Dst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc1Grouping)arg).isNxNshc1Dst();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc1Grouping]");
    }

    public Boolean isNxNshc1Dst() {
        return _nxNshc1Dst;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<SrcNxNshc1Case>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcNxNshc1CaseBuilder setNxNshc1Dst(final Boolean value) {
        this._nxNshc1Dst = value;
        return this;
    }
    
    public SrcNxNshc1CaseBuilder addAugmentation(Class<? extends Augmentation<SrcNxNshc1Case>> augmentationType, Augmentation<SrcNxNshc1Case> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcNxNshc1CaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxNshc1Case>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxNshc1Case build() {
        return new SrcNxNshc1CaseImpl(this);
    }

    private static final class SrcNxNshc1CaseImpl implements SrcNxNshc1Case {
    
        private final Boolean _nxNshc1Dst;
    
        private Map<Class<? extends Augmentation<SrcNxNshc1Case>>, Augmentation<SrcNxNshc1Case>> augmentation = Collections.emptyMap();
    
        SrcNxNshc1CaseImpl(SrcNxNshc1CaseBuilder base) {
            this._nxNshc1Dst = base.isNxNshc1Dst();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<SrcNxNshc1Case> getImplementedInterface() {
            return SrcNxNshc1Case.class;
        }
    
        @Override
        public Boolean isNxNshc1Dst() {
            return _nxNshc1Dst;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<SrcNxNshc1Case>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxNshc1Dst);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcNxNshc1Case.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrcNxNshc1Case other = (SrcNxNshc1Case)obj;
            if (!Objects.equals(_nxNshc1Dst, other.isNxNshc1Dst())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcNxNshc1CaseImpl otherImpl = (SrcNxNshc1CaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcNxNshc1Case>>, Augmentation<SrcNxNshc1Case>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcNxNshc1Case");
            CodeHelpers.appendValue(helper, "_nxNshc1Dst", _nxNshc1Dst);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
