package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg.Src;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxOutputRegBuilder} instances.
 *
 * @see NxOutputRegBuilder
 *
 */
public class NxOutputRegBuilder implements Builder<NxOutputReg> {

    private Integer _maxLen;
    private Src _src;


    Map<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>> augmentation = Collections.emptyMap();

    public NxOutputRegBuilder() {
    }

    public NxOutputRegBuilder(NxOutputReg base) {
        this._maxLen = base.getMaxLen();
        this._src = base.getSrc();
        if (base instanceof NxOutputRegImpl) {
            NxOutputRegImpl impl = (NxOutputRegImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>> aug =((AugmentationHolder<NxOutputReg>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    public Integer getMaxLen() {
        return _maxLen;
    }
    
    public Src getSrc() {
        return _src;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxOutputReg>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkMaxLenRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public NxOutputRegBuilder setMaxLen(final Integer value) {
    if (value != null) {
        checkMaxLenRange(value);
        
    }
        this._maxLen = value;
        return this;
    }
    
    public NxOutputRegBuilder setSrc(final Src value) {
        this._src = value;
        return this;
    }
    
    public NxOutputRegBuilder addAugmentation(Class<? extends Augmentation<NxOutputReg>> augmentationType, Augmentation<NxOutputReg> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxOutputRegBuilder removeAugmentation(Class<? extends Augmentation<NxOutputReg>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxOutputReg build() {
        return new NxOutputRegImpl(this);
    }

    private static final class NxOutputRegImpl implements NxOutputReg {
    
        private final Integer _maxLen;
        private final Src _src;
    
        private Map<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>> augmentation = Collections.emptyMap();
    
        NxOutputRegImpl(NxOutputRegBuilder base) {
            this._maxLen = base.getMaxLen();
            this._src = base.getSrc();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxOutputReg> getImplementedInterface() {
            return NxOutputReg.class;
        }
    
        @Override
        public Integer getMaxLen() {
            return _maxLen;
        }
        
        @Override
        public Src getSrc() {
            return _src;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxOutputReg>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_maxLen);
            result = prime * result + Objects.hashCode(_src);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxOutputReg.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxOutputReg other = (NxOutputReg)obj;
            if (!Objects.equals(_maxLen, other.getMaxLen())) {
                return false;
            }
            if (!Objects.equals(_src, other.getSrc())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxOutputRegImpl otherImpl = (NxOutputRegImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxOutputReg");
            CodeHelpers.appendValue(helper, "_maxLen", _maxLen);
            CodeHelpers.appendValue(helper, "_src", _src);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
