package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DstNxNshc4CaseBuilder} instances.
 *
 * @see DstNxNshc4CaseBuilder
 *
 */
public class DstNxNshc4CaseBuilder implements Builder<DstNxNshc4Case> {

    private Boolean _nxNshc4Dst;


    Map<Class<? extends Augmentation<DstNxNshc4Case>>, Augmentation<DstNxNshc4Case>> augmentation = Collections.emptyMap();

    public DstNxNshc4CaseBuilder() {
    }
    public DstNxNshc4CaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc4Grouping arg) {
        this._nxNshc4Dst = arg.isNxNshc4Dst();
    }

    public DstNxNshc4CaseBuilder(DstNxNshc4Case base) {
        this._nxNshc4Dst = base.isNxNshc4Dst();
        if (base instanceof DstNxNshc4CaseImpl) {
            DstNxNshc4CaseImpl impl = (DstNxNshc4CaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DstNxNshc4Case>>, Augmentation<DstNxNshc4Case>> aug =((AugmentationHolder<DstNxNshc4Case>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc4Grouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc4Grouping) {
            this._nxNshc4Dst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc4Grouping)arg).isNxNshc4Dst();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc4Grouping]");
    }

    public Boolean isNxNshc4Dst() {
        return _nxNshc4Dst;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<DstNxNshc4Case>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstNxNshc4CaseBuilder setNxNshc4Dst(final Boolean value) {
        this._nxNshc4Dst = value;
        return this;
    }
    
    public DstNxNshc4CaseBuilder addAugmentation(Class<? extends Augmentation<DstNxNshc4Case>> augmentationType, Augmentation<DstNxNshc4Case> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstNxNshc4CaseBuilder removeAugmentation(Class<? extends Augmentation<DstNxNshc4Case>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstNxNshc4Case build() {
        return new DstNxNshc4CaseImpl(this);
    }

    private static final class DstNxNshc4CaseImpl implements DstNxNshc4Case {
    
        private final Boolean _nxNshc4Dst;
    
        private Map<Class<? extends Augmentation<DstNxNshc4Case>>, Augmentation<DstNxNshc4Case>> augmentation = Collections.emptyMap();
    
        DstNxNshc4CaseImpl(DstNxNshc4CaseBuilder base) {
            this._nxNshc4Dst = base.isNxNshc4Dst();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<DstNxNshc4Case> getImplementedInterface() {
            return DstNxNshc4Case.class;
        }
    
        @Override
        public Boolean isNxNshc4Dst() {
            return _nxNshc4Dst;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<DstNxNshc4Case>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxNshc4Dst);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DstNxNshc4Case.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DstNxNshc4Case other = (DstNxNshc4Case)obj;
            if (!Objects.equals(_nxNshc4Dst, other.isNxNshc4Dst())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstNxNshc4CaseImpl otherImpl = (DstNxNshc4CaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DstNxNshc4Case>>, Augmentation<DstNxNshc4Case>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DstNxNshc4Case");
            CodeHelpers.appendValue(helper, "_nxNshc4Dst", _nxNshc4Dst);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
