/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.in.port.grouping;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.in.port.grouping.OfInPort;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OfInPortBuilder
implements Builder<OfInPort> {
    private Integer _value;
    Map<Class<? extends Augmentation<OfInPort>>, Augmentation<OfInPort>> augmentation = Collections.emptyMap();

    public OfInPortBuilder() {
    }

    public OfInPortBuilder(OfInPort base) {
        Map aug;
        this._value = base.getValue();
        if (base instanceof OfInPortImpl) {
            OfInPortImpl impl = (OfInPortImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<OfInPort>>, Augmentation<OfInPort>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OfInPort>>, Augmentation<OfInPort>>(aug);
        }
    }

    public Integer getValue() {
        return this._value;
    }

    public <E$$ extends Augmentation<OfInPort>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkValueRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (Object)value);
    }

    public OfInPortBuilder setValue(Integer value) {
        if (value != null) {
            OfInPortBuilder.checkValueRange(value);
        }
        this._value = value;
        return this;
    }

    public OfInPortBuilder addAugmentation(Class<? extends Augmentation<OfInPort>> augmentationType, Augmentation<OfInPort> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OfInPort>>, Augmentation<OfInPort>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public OfInPortBuilder removeAugmentation(Class<? extends Augmentation<OfInPort>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public OfInPort build() {
        return new OfInPortImpl(this);
    }

    private static final class OfInPortImpl
    implements OfInPort {
        private final Integer _value;
        private Map<Class<? extends Augmentation<OfInPort>>, Augmentation<OfInPort>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        OfInPortImpl(OfInPortBuilder base) {
            this._value = base.getValue();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<OfInPort> getImplementedInterface() {
            return OfInPort.class;
        }

        @Override
        public Integer getValue() {
            return this._value;
        }

        public <E$$ extends Augmentation<OfInPort>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._value);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OfInPort.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            OfInPort other = (OfInPort)obj;
            if (!Objects.equals(this._value, other.getValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OfInPortImpl otherImpl = (OfInPortImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<OfInPort>>, Augmentation<OfInPort>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"OfInPort");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (Object)this._value);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

